package ru.yandex.autotests.direct.api.adgroups.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.GetResponse;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
/**
 * Author pavryabov
 * Date 10.10.14
 * https://st.yandex-team.ru/TESTIRT-2022
 */
@Aqua.Test
@Features(AdGroupsFeatures.GET)
@Stories(AdGroupsStories.AUTHORIZATION)
@RunWith(Parameterized.class)
public class ClientCheckRightsToGetTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static final String client = AdGroupsLogins.CLIENT;
    private static final String clientRep = AdGroupsLogins.CLIENT_REP;
    private static final String otherClient = AdGroupsLogins.CLIENT_ELSE;

    static Long campaignId;
    static Long notMineCampaignId;

    @Parameterized.Parameter(0)
    public String loginForAuthorization;

    @Parameterized.Parameter(1)
    public String loginForHeader;

    @Parameterized.Parameters(name = "loginForAuthorization = {0}, loginForHeader = {1}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {client, null},
                {clientRep, null},
                {client, client},
                {client, clientRep},
                {clientRep, client},
                {clientRep, clientRep}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void createNotMineCampaign() {
        api.userSteps.clientFakeSteps().reshardUserWithLock(client, ShardNumbers.DEFAULT_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(otherClient, ShardNumbers.DEFAULT_SHARD);
        campaignId = api.as(client).userSteps.campaignSteps().addDefaultTextCampaign(client);
        api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        notMineCampaignId = api.as(otherClient).userSteps.campaignSteps().addDefaultTextCampaign(otherClient);
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(loginForAuthorization);
    }

    @Test
    public void callGetWithLoginInHeader() {
        //DIRECT-34845
        GetResponse response = api.as(loginForAuthorization).userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap().withSelectionCriteria(
                        new AdGroupsSelectionCriteriaMap().withCampaignIds(campaignId))
                        .withFieldNames(AdGroupFieldEnum.CAMPAIGN_ID),
                loginForHeader
        );
        assertThat("вернулось правильное количество групп", response.getAdGroups().size(), equalTo(1));
    }

    @Test
    public void callGetWithNotMineCampaign() {
        //DIRECT-34845
        GetResponse response = api.as(loginForAuthorization).userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap().withSelectionCriteria(
                        new AdGroupsSelectionCriteriaMap().withCampaignIds(notMineCampaignId))
                        .withFieldNames(AdGroupFieldEnum.CAMPAIGN_ID),
                loginForHeader
        );
        assertThat("вернулось правильное количество групп", response.getAdGroups().size(), equalTo(0));
    }
}
