package ru.yandex.autotests.direct.api.adgroups.get;

import java.util.Arrays;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.AdGroupGetItem;
import com.yandex.direct.api.v5.adgroups.GetResponse;
import com.yandex.direct.api.v5.general.ServingStatusEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupGetItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by gerdler on 20.01.17.
 * https://st.yandex-team.ru/TESTIRT-10918
 */
@Aqua.Test
@Features(AdGroupsFeatures.GET)
@Description("Проверка фильтрации по полю ServingStatus в архивной текстовой кампании")
@Issue("https://st.yandex-team.ru/DIRECT-62560")
public class GetIsBsRarelyLoadedFilteredForArchivedTextCampaignTest {
    private static long campaignId;
    private static int shard;
    private static final String CLIENT = AdGroupsLogins.CLIENT;
    private static long adGroupRarelyServed;
    private static long adGroupEligible;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void setUp() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupEligible = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adGroupRarelyServed = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        DirectJooqDbSteps directJooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT);
        directJooqDbSteps.adGroupsSteps().setBsRarelyLoaded(adGroupEligible, false);
        directJooqDbSteps.adGroupsSteps().setBsRarelyLoaded(adGroupRarelyServed, true);
        api.userSteps.campaignSteps().campaignsSuspend(campaignId);
        api.userSteps.campaignSteps().campaignsArchive(campaignId);
    }

    @Test
    public void checkFilterByCampaignIdsAndEligible() {
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                    .withSelectionCriteria(
                            new AdGroupsSelectionCriteriaMap()
                                .withServingStatuses(ServingStatusEnum.ELIGIBLE)
                                .withCampaignIds(campaignId))
                    .withFieldNames(AdGroupFieldEnum.ID)
        );
        assumeThat("выбрались обе группы", response.getAdGroups(), hasSize(2));
        assertThat(
                "выбрались правильные группы",
                response.getAdGroups(),
                beanDifferV5(
                        Arrays.asList(
                                (AdGroupGetItem) new AdGroupGetItemMap().withId(adGroupEligible).getBean(),
                                (AdGroupGetItem) new AdGroupGetItemMap().withId(adGroupRarelyServed).getBean()
                        )
                )
        );
    }

    @Test
    public void checkFilterByCampaignIdsAndRarelyServed() {
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withServingStatuses(ServingStatusEnum.RARELY_SERVED)
                                        .withCampaignIds(campaignId))
                        .withFieldNames(AdGroupFieldEnum.ID)
        );
        assertThat("не выбралось ни одной группы", response.getAdGroups(), empty());
    }

    @Test
    public void checkFilterByAdGroupIdsAndEligible() {
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withServingStatuses(ServingStatusEnum.ELIGIBLE)
                                        .withIds(adGroupEligible, adGroupRarelyServed))
                        .withFieldNames(AdGroupFieldEnum.ID)
        );
        assertThat("выбрались обе группы", response.getAdGroups(), hasSize(2));
    }

    @Test
    public void checkFilterByAdGroupIdsAndRarelyServed() {
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withServingStatuses(ServingStatusEnum.RARELY_SERVED)
                                        .withIds(adGroupEligible, adGroupRarelyServed))
                        .withFieldNames(AdGroupFieldEnum.ID)
        );
        assertThat("не выбралось ни одной группы", response.getAdGroups(), empty());
    }
}
