package ru.yandex.autotests.direct.api.adgroups.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.GetResponse;
import com.yandex.direct.api.v5.general.ServingStatusEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by onotole on 26.12.16.
 * https://st.yandex-team.ru/TESTIRT-10828
 */
@Aqua.Test
@Features(AdGroupsFeatures.GET)
@Description("Проверка фильтрации по полю ServingStatus")
@Issue("https://st.yandex-team.ru/DIRECT-61798")
@RunWith(Parameterized.class)
public class GetIsBsRarelyLoadedFilteredTest {
    private static long campaignId;
    private static final String CLIENT = AdGroupsLogins.CLIENT;
    private static long adGroupRarelyServed;
    private static long adGroupEligible;
    private static long expectedAdGroupId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public ServingStatusEnum servingStatus;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> testDate() {
        return Arrays.asList(new Object[][] {
                {ServingStatusEnum.RARELY_SERVED},
                {ServingStatusEnum.ELIGIBLE}
        });
    }

    @BeforeClass
    public static void setUp() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupEligible = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adGroupRarelyServed = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        DirectJooqDbSteps directJooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT);
        directJooqDbSteps.adGroupsSteps().setBsRarelyLoaded(adGroupEligible, false);
        directJooqDbSteps.adGroupsSteps().setBsRarelyLoaded(adGroupRarelyServed, true);
    }

    @Test
    public void checkFilterCampaignIds() {
        expectedAdGroupId = (servingStatus == ServingStatusEnum.ELIGIBLE) ? adGroupEligible : adGroupRarelyServed;
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                    .withSelectionCriteria(
                            new AdGroupsSelectionCriteriaMap()
                                .withServingStatuses(servingStatus)
                                .withCampaignIds(campaignId))
                    .withFieldNames(AdGroupFieldEnum.ID)
        );
        assumeThat("adGroup с неверным значением ServingStatus отфильтровалась", response.getAdGroups(), hasSize(1));
        assertThat("adGroup с правильным значением ServingStatus прошла фильтрацию", response.getAdGroups().get(0).getId(), equalTo(expectedAdGroupId));
    }

    @Test
    public void checkFilterAdGroupIds() {
        expectedAdGroupId = (servingStatus == ServingStatusEnum.ELIGIBLE) ? adGroupEligible : adGroupRarelyServed;
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(adGroupEligible, adGroupRarelyServed)
                                        .withServingStatuses(servingStatus))
                        .withFieldNames(AdGroupFieldEnum.ID)
        );
        assumeThat("adGroup с неверным значением ServingStatus отфильтровалась", response.getAdGroups(), hasSize(1));
        assertThat("adGroup с правильным значением ServingStatus прошла фильтрацию", response.getAdGroups().get(0).getId(), equalTo(expectedAdGroupId));
    }
}
