package ru.yandex.autotests.direct.api.adgroups.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.GetResponse;
import com.yandex.direct.api.v5.general.ServingStatusEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by onotole on 23.12.16.
 * https://st.yandex-team.ru/TESTIRT-10828
 */
@Aqua.Test
@Features(AdGroupsFeatures.GET)
@Description("ServingStatus отдается правильно")
@Issue("https://st.yandex-team.ru/DIRECT-61798")
@RunWith(Parameterized.class)
public class GetIsBsRarelyLoadedTest {
    private static final String CLIENT = AdGroupsLogins.CLIENT;
    private static long textCampaignId;
    private static long mobileAppCampaignId;
    private static long archivedTextCampaignId;
    private static long archivedMobileAppCampaignId;
    private static long dynamicCampaignId;
    private static long cpmBannerCampaignId;
    private static long textAdGroupId;
    private static long mobileAppAdGroupId;
    private static long archivedTextAdGroupId;
    private static long archivedMobileAppAdGroupId;
    private static long dynamicAdGroupId;
    private static long cpmBannerAdGroupId;
    private static DirectJooqDbSteps directJooqDbSteps;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public boolean bsRarelyLoaded;

    @Parameterized.Parameter(1)
    public ServingStatusEnum expectedServingStatus;

    @Parameterized.Parameters(name = "{1}")
    public static Collection<Object[]> testData() {
        return Arrays.asList(new Object[][]{
                {true, ServingStatusEnum.RARELY_SERVED},
                {false, ServingStatusEnum.ELIGIBLE}
        });
    }

    @BeforeClass
    public static void prepare() {
        textCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        mobileAppCampaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        archivedTextCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        archivedMobileAppCampaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        dynamicCampaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        cpmBannerCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().setType(cpmBannerCampaignId, CampaignsType.CPM_BANNER);
        textAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(textCampaignId);
        mobileAppAdGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(mobileAppCampaignId);
        archivedTextAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(archivedTextCampaignId);
        archivedMobileAppAdGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(archivedMobileAppCampaignId);
        dynamicAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(dynamicCampaignId);
        cpmBannerAdGroupId = api.userSteps.adGroupsSteps().addDefaultCpmBannerUserProfileAdGroup(cpmBannerCampaignId);
        api.userSteps.campaignSteps().campaignsSuspend(archivedTextCampaignId, archivedMobileAppCampaignId);
        api.userSteps.campaignSteps().campaignsArchive(archivedTextCampaignId, archivedMobileAppCampaignId);
        directJooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT);
    }

    @Test
    public void checkServingStatusTextCampaign() {
        directJooqDbSteps.adGroupsSteps().setBsRarelyLoaded(textAdGroupId, bsRarelyLoaded);
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(textAdGroupId)
                        )
                        .withFieldNames(AdGroupFieldEnum.SERVING_STATUS)
        );
        assumeThat("вернулась правильное количество adGroup", response.getAdGroups(), hasSize(1));
        assertThat("вернулось правильное значение SERVING STATUS", response.getAdGroups().get(0).getServingStatus(),
                equalTo(expectedServingStatus));
    }

    @Test
    public void checkServingStatusMobileAppCampaign() {
        directJooqDbSteps.adGroupsSteps().setBsRarelyLoaded(mobileAppAdGroupId, bsRarelyLoaded);
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(mobileAppAdGroupId)
                        )
                        .withFieldNames(AdGroupFieldEnum.SERVING_STATUS)
        );
        assumeThat("вернулась одна группа", response.getAdGroups(), hasSize(1));
        assertThat("вернулось правильное значение SERVING STATUS", response.getAdGroups().get(0).getServingStatus(),
                equalTo(expectedServingStatus));
    }

    @Test
    public void checkServingStatusCpmBannerCampaign() {
        directJooqDbSteps.adGroupsSteps().setBsRarelyLoaded(cpmBannerAdGroupId, bsRarelyLoaded);
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(cpmBannerAdGroupId)
                        )
                        .withFieldNames(AdGroupFieldEnum.SERVING_STATUS)
        );
        assumeThat("вернулась одна группа", response.getAdGroups(), hasSize(1));
        assertThat("вернулось правильное значение SERVING STATUS", response.getAdGroups().get(0).getServingStatus(),
                equalTo(expectedServingStatus));
    }

    @Test
    public void checkServingStatusForArchivedTextCampaign() {
        directJooqDbSteps.adGroupsSteps().setBsRarelyLoaded(archivedTextAdGroupId, bsRarelyLoaded);
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(archivedTextAdGroupId)
                        )
                        .withFieldNames(AdGroupFieldEnum.SERVING_STATUS)
        );
        assumeThat("вернулась одна группа", response.getAdGroups(), hasSize(1));
        assertThat("вернулось правильное значение SERVING STATUS", response.getAdGroups().get(0).getServingStatus(),
                equalTo(ServingStatusEnum.ELIGIBLE));
    }

    @Test
    public void checkServingStatusForArchivedMobileAppCampaign() {
        directJooqDbSteps.adGroupsSteps().setBsRarelyLoaded(archivedMobileAppAdGroupId, bsRarelyLoaded);
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(archivedMobileAppAdGroupId)
                        )
                        .withFieldNames(AdGroupFieldEnum.SERVING_STATUS)
        );
        assumeThat("вернулась одна группа", response.getAdGroups(), hasSize(1));
        assertThat("вернулось правильное значение SERVING STATUS", response.getAdGroups().get(0).getServingStatus(),
                equalTo(ServingStatusEnum.ELIGIBLE));
    }

    @Test
    public void checkServingStatusForDynamicCampaign() {
        directJooqDbSteps.adGroupsSteps().setBsRarelyLoaded(dynamicAdGroupId, bsRarelyLoaded);
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(dynamicAdGroupId)
                        )
                        .withFieldNames(AdGroupFieldEnum.SERVING_STATUS)
        );
        assumeThat("вернулась одна группа", response.getAdGroups(), hasSize(1));
        assertThat("вернулось правильное значение SERVING STATUS", response.getAdGroups().get(0).getServingStatus(),
                equalTo(ServingStatusEnum.ELIGIBLE));
    }
}
