package ru.yandex.autotests.direct.api.adgroups.get;

import java.util.Arrays;
import java.util.HashMap;
import java.util.stream.Stream;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.general.StatusEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.stream.Collectors.joining;
import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.apache.commons.lang3.StringUtils.uncapitalize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by pavryabov on 10.12.14.
 * https://st.yandex-team.ru/TESTIRT-3706
 */
@Aqua.Test
@Features(AdGroupsFeatures.GET)
@Stories(ApiStories.JSON5)
public class GetJSONTest {

    private static final String client = AdGroupsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).protocol(ProtocolType.JSON).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    static Long campaignId;
    static Long id;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdGroupsLogins.CLIENT);
        id = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    private static class JSONObject extends HashMap<String, Object> {
    }

    @Test
    public void invalidFieldInFieldNames() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdGroupsSelectionCriteriaMap.IDS), new Long[]{id});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES),
                new String[]{capitalize(AdGroupFieldEnum.ID.toString())});
        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsGet(
                request,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                        capitalize(GetRequestMap.FIELD_NAMES),
                        Arrays.stream(AdGroupFieldEnum.values()).map(AdGroupFieldEnum::value)
                                .collect(joining(", "))));
    }

    @Test
    public void invalidFieldInSelectionCriteria() {
        //DIRECT-37561
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdGroupsSelectionCriteriaMap.IDS), new Long[]{id});
        selectionCriteria.put(AdGroupsSelectionCriteriaMap.IDS, new Long[]{id});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new String[]{AdGroupFieldEnum.ID.value()});
        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.UNKNOWN_PARAMETER,
                        capitalize(GetRequestMap.SELECTION_CRITERIA) + "."
                                + AdGroupsSelectionCriteriaMap.IDS));
    }

    @Test
    public void invalidStatus() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdGroupsSelectionCriteriaMap.IDS), new Long[]{id});
        selectionCriteria.put(capitalize(AdGroupsSelectionCriteriaMap.STATUSES),
                new String[]{uncapitalize(StatusEnum.ACCEPTED.toString())});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new String[]{AdGroupFieldEnum.ID.value()});
        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsGet(
                request,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                        path(GetRequestMap.SELECTION_CRITERIA, AdGroupsSelectionCriteriaMap.STATUSES),
                        Stream.of(StatusEnum.ACCEPTED, StatusEnum.DRAFT, StatusEnum.MODERATION,
                                StatusEnum.REJECTED, StatusEnum.PREACCEPTED)
                                .map(Object::toString)
                                .collect(joining(", "))));
    }

    @Test
    public void getWithNotArrayInIds() {
        //DIRECT-37558
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdGroupsSelectionCriteriaMap.IDS), id);
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new String[]{AdGroupFieldEnum.ID.value()});
        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                        path(GetRequestMap.SELECTION_CRITERIA, AdGroupsSelectionCriteriaMap.IDS)));
    }

    @Test
    public void getWithNotArrayInFieldNames() {
        //DIRECT-37558
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdGroupsSelectionCriteriaMap.IDS), new Long[]{id});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), AdGroupFieldEnum.ID);
        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_ARRAY, capitalize(GetRequestMap.FIELD_NAMES))
        );
    }
}
