package ru.yandex.autotests.direct.api.adgroups.get;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.AdGroupGetItem;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.cases.MinusWordsStorageCases;
import ru.yandex.autotests.directapi.converters.MinusWordsSerializer;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Collections.singletonList;
import static org.hamcrest.Matchers.containsInAnyOrder;
import static org.junit.Assert.assertThat;

/**
 * Created by andy-ilyin on 13.09.16.
 * https://st.yandex-team.ru/TESTIRT-10213
 */
@Aqua.Test
@Features(AdGroupsFeatures.GET)
@Tag(TagDictionary.TRUNK)
@Issue("https://st.yandex-team.ru/DIRECT-55547")
@Description("Проверка работы метода с новым JSON форматом минус-слов")
@RunWith(Parameterized.class)
public class GetNegativeKeywordsStorageTest {
    private static final List<MinusWordsSerializer> minusWordSerializers =
            singletonList(MinusWordsSerializer.CURRENT_SERIALIZER);

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(AdGroupsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static DirectJooqDbSteps dbSteps;
    private static Long adGroupId;
    private static Long clientId;

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter
    public String description;

    @Parameterized.Parameter(1)
    public String[] negativeKeywords;

    @Parameterized.Parameter(2)
    public MinusWordsSerializer minusWordSerializer;

    private Long originalMwId;
    private Long tempMwId;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> testData() {
        List<Object[]> result = new LinkedList<>();
        for (MinusWordsStorageCases.TestCase testCase : MinusWordsStorageCases.getTestCases()) {
            for (MinusWordsSerializer minusWordsSerializer : minusWordSerializers) {
                result.add(new Object[]{
                        testCase.getDescription() + " (" + minusWordsSerializer.toString() + ")",
                        testCase.getMinusWords().toArray(),
                        minusWordsSerializer
                });
            }
        }
        return result;
    }

    @BeforeClass
    public static void createCampaignAndAdGroup() {
        clientId = Long.valueOf(api.userSteps.clientFakeSteps().getClientData(AdGroupsLogins.CLIENT).getClientID());
        dbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(AdGroupsLogins.CLIENT);

        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
    }

    @Before
    public void setUpMinusWords() {
        originalMwId = dbSteps.adGroupsSteps().getPhrases(adGroupId).getMwId();
        tempMwId = dbSteps.minusWordsSteps().createRecord(
                clientId, minusWordSerializer.write(Arrays.asList(negativeKeywords)));
        dbSteps.adGroupsSteps().setMwId(adGroupId, tempMwId);
    }

    @Test
    public void testNegativeKeywordStorage() {
        AdGroupGetItem adGroupGetItem = api.userSteps.adGroupsSteps()
                .getAdGroup(adGroupId, AdGroupFieldEnum.NEGATIVE_KEYWORDS);
        assertThat("минус-слова в ответе такие же, как сохранили в базу",
                adGroupGetItem.getNegativeKeywords().getValue().getItems(),
                containsInAnyOrder(negativeKeywords));
    }

    @After
    public void tearDownMinusWords() {
        dbSteps.adGroupsSteps().setMwId(adGroupId, originalMwId);
        if (tempMwId != null) {
            dbSteps.minusWordsSteps().deleteRecord(tempMwId);
        }
    }
}
