package ru.yandex.autotests.direct.api.adgroups.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.GetResponse;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Issues;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 22.06.16.
 * https://st.yandex-team.ru/TESTIRT-9520
 */
@Aqua.Test
@Features(AdGroupsFeatures.GET)
@Description("Группы неподдерживаемых типов не должны возвращаться")
@Issues({@Issue("https://st.yandex-team.ru/DIRECT-46973"),
        @Issue("https://st.yandex-team.ru/DIRECT-66999")})
@RunWith(Parameterized.class)
public class GetNotSupportedAdGroupTypeTest {
    private static final String LOGIN = AdGroupsLogins.CLIENT;
    private static int shard;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long adGroupId;

    @Parameterized.Parameter()
    public CampaignsType campaignsType;

    @Parameterized.Parameter(1)
    public PhrasesAdgroupType adgroupType;

    @Parameterized.Parameters(name = "campaignsType:{0}, adgroupType:{1}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {CampaignsType.MCBANNER, PhrasesAdgroupType.base},
        });
    }

    @BeforeClass
    public static void init() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void createTestData() {
        long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);

        api.userSteps.campaignFakeSteps().setType(campaignId, campaignsType);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps()
                .setType(adGroupId, adgroupType);
    }

    @Test
    public void getAdGroup() {
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(adGroupId)
                        )
                        .withFieldNames(AdGroupFieldEnum.ID) 
        );
        assertThat("группа типа " + adgroupType.getName() + " не получена", response.getAdGroups(), hasSize(0));
    }

}
