package ru.yandex.autotests.direct.api.adgroups.get;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.AdGroupSubtypeEnum;
import com.yandex.direct.api.v5.adgroups.GetResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupGetItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Author gerdler
 * https://st.yandex-team.ru/TESTIRT-10035
 */
@Aqua.Test
@Features(AdGroupsFeatures.GET)
@Issue("https://st.yandex-team.ru/DIRECT-55195")
@Description("Проверка получения правильных подтипов для разных типов групп")
@RunWith(Parameterized.class)
public class GetSubtypeTest {
    private static final String LOGIN = AdGroupsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String adGroupType;

    @Parameterized.Parameter(1)
    public Long adGroupId;

    @Parameterized.Parameter(2)
    public AdGroupSubtypeEnum subtype;

    private static Long textAdGroupId;
    private static Long mobileAppAdGroupId;
    private static Long dynamicTextAdGroupId;
    private static Long dynamicTextFeedAdGroupId;
    private static Long cpmBannerUserProfileAdGroupId;
    private static Long cpmBannerKeywordsAdGroupId;
    private static Long cpmVideoAdGroupId;

    @Parameterized.Parameters(name = "AdGroup Type = {0}")
    public static Collection testData() {
        Long textCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        textAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(textCampaignId);
        Long mobileAppCampaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        mobileAppAdGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(mobileAppCampaignId);
        Long dynamicTextCampaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        dynamicTextAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(dynamicTextCampaignId);
        dynamicTextFeedAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(dynamicTextCampaignId);
        int shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        Long feedId = jooqDbSteps.feedsSteps().createDefaultFeed(User.get(LOGIN).getClientID());
        jooqDbSteps.adGroupsSteps().convertAdgroupDynamicToDynamicByFeed(dynamicTextFeedAdGroupId, feedId);
        Long cpmBannerCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().setType(cpmBannerCampaignId, CampaignsType.CPM_BANNER);
        cpmBannerUserProfileAdGroupId =
                api.userSteps.adGroupsSteps().addDefaultCpmBannerUserProfileAdGroup(cpmBannerCampaignId);
        cpmBannerKeywordsAdGroupId =
                api.userSteps.adGroupsSteps().addDefaultCpmBannerKeywordsAdGroup(cpmBannerCampaignId);
        cpmVideoAdGroupId =
                api.userSteps.adGroupsSteps().addDefaultCpmVideoGroup(cpmBannerCampaignId);

        Object[][] data = new Object[][]{
                {"Text", textAdGroupId, AdGroupSubtypeEnum.NONE},
                {"MobileApp", mobileAppAdGroupId, AdGroupSubtypeEnum.NONE},
                {"DynamicText", dynamicTextAdGroupId, AdGroupSubtypeEnum.WEBPAGE},
                {"DynamicTextFeed", dynamicTextFeedAdGroupId, AdGroupSubtypeEnum.FEED},
                {"CpmBannerUserProfile", cpmBannerUserProfileAdGroupId, AdGroupSubtypeEnum.USER_PROFILE},
                {"CpmBannerKeywords", cpmBannerKeywordsAdGroupId, AdGroupSubtypeEnum.KEYWORDS},
                {"CpmVideo", cpmVideoAdGroupId, AdGroupSubtypeEnum.NONE}
        };
        return Arrays.asList(data);
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    public void getAdGroupSubtype() {
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(adGroupId)
                        )
                        .withFieldNames(AdGroupFieldEnum.ID, AdGroupFieldEnum.SUBTYPE)
        );
        assertThat("подтип группы вернулся правильно", response.getAdGroups(),
                beanDifferV5(Collections.singletonList(
                        new AdGroupGetItemMap().withId(adGroupId).withSubtype(subtype).getBean()))
        );
    }

}
