package ru.yandex.autotests.direct.api.adgroups.get;

import java.util.Arrays;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.GetResponse;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static com.sun.xml.ws.util.StringUtils.capitalize;
import static java.util.stream.Collectors.joining;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Author pavryabov
 * Date 10.10.14
 * https://jira.yandex-team.ru/browse/TESTIRT-2022
 */
@Aqua.Test
@Features(AdGroupsFeatures.GET)
@Tag(TagDictionary.TRUNK)
public class GetTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(AdGroupsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long campaignId;
    static Long adGroupId;
    static Long adId;
    private static final String PARAMS = "params";

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdGroupsLogins.CLIENT);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
    }

    @Test
    public void getWithoutSelectionCriteria() {
        //DIRECT-33530
        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsGet(
                new GetRequestMap()
                        .withFieldNames(AdGroupFieldEnum.CAMPAIGN_ID),
                new Api5Error(8000,
                        Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(GetRequestMap.SELECTION_CRITERIA)));
    }

    @Test
    public void getWithoutFieldNames() {
        //DIRECT-33530
        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withCampaignIds(campaignId)
                        ),
                new Api5Error(8000,
                        Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(GetRequestMap.FIELD_NAMES)));
    }

    @Test
    public void getWithInvalidFieldInFieldNames() {
        //DIRECT-33530
        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(campaignId)
                        )
                        .withFieldNames(
                                AdGroupFieldEnum.CAMPAIGN_ID.value().toLowerCase()
                        ),
                new Api5Error(8000,
                        Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                        capitalize(GetRequestMap.FIELD_NAMES),
                        Arrays.stream(AdGroupFieldEnum.values())
                                .map(AdGroupFieldEnum::value)
                                .collect(joining(", "))));
    }

    @Test
    public void getWithValidAndInvalidFieldsInFieldNames() {
        //DIRECT-33530
        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(campaignId)
                        )
                        .withFieldNames(
                                AdGroupFieldEnum.ID.value(),
                                AdGroupFieldEnum.CAMPAIGN_ID.value().toLowerCase()
                        ),
                new Api5Error(8000,
                        Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                        capitalize(GetRequestMap.FIELD_NAMES),
                        Arrays.stream(AdGroupFieldEnum.values())
                                .map(AdGroupFieldEnum::value)
                                .collect(joining(", "))));
    }

    @Test
    public void getGroupAfterDeleteAllBannersFromIt() {
        //DIRECT-35705
        api.userSteps.adsSteps().adsDelete(adId);
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(adId)
                        )
                        .withFieldNames(AdGroupFieldEnum.ID)
        );
        assertThat("после удаления всех баннеров группа удаляется", response.getAdGroups().size(), equalTo(0));
    }
}
