package ru.yandex.autotests.direct.api.adgroups.get;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.GetResponse;
import com.yandex.direct.api.v5.general.AdGroupTypesEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupGetItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.MobileAppAdGroupAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Collections;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Author buhter
 * https://st.yandex-team.ru/TESTIRT-7178
 */
@Aqua.Test
@Features(AdGroupsFeatures.GET)
@Issue("https://st.yandex-team.ru/DIRECT-44780")
public class GetTypeFilterTest {
    private static final String LOGIN = AdGroupsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static AdGroupAddItemMap adGroupAddItemMap;
    private static Long campaignId;
    private Long id;
    private static Long dynamicTextAdGroupId;
    private static Long dynamicTextFeedAdGroupId;

    @BeforeClass
    public static void initTest() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        dynamicTextAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
        dynamicTextFeedAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
        int shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        Long feedId = jooqDbSteps.feedsSteps().createDefaultFeed(User.get(LOGIN).getClientID());
        jooqDbSteps.adGroupsSteps().convertAdgroupDynamicToDynamicByFeed(dynamicTextFeedAdGroupId, feedId);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void before() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        adGroupAddItemMap = new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    public void getGroupWithMobileTypeAndMobileFilter() {
        api.userSteps.campaignFakeSteps().setType(campaignId, CampaignsType.MOBILE_CONTENT);
        id = api.userSteps.adGroupsSteps().addGroup(adGroupAddItemMap.withMobileAppAdGroup(
                new MobileAppAdGroupAddMap().defaultGroup()));
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(id)
                                        .withTypes(AdGroupTypesEnum.MOBILE_APP_AD_GROUP)
                        )
                        .withFieldNames(AdGroupFieldEnum.TYPE)
        );
        assumeThat("AdGroups.get вернул одну группу", response.getAdGroups(), hasSize(1));
        assertThat("тип группы вернулся правильно",
                response.getAdGroups().get(0).getType(), equalTo(AdGroupTypesEnum.MOBILE_APP_AD_GROUP));
    }

    @Test
    public void getGroupWithMobileTypeAndTextFilter() {
        api.userSteps.campaignFakeSteps().setType(campaignId, CampaignsType.MOBILE_CONTENT);
        id = api.userSteps.adGroupsSteps().addGroup(adGroupAddItemMap.withMobileAppAdGroup(
                new MobileAppAdGroupAddMap().defaultGroup()));
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(id)
                                        .withTypes(AdGroupTypesEnum.TEXT_AD_GROUP)
                        )
                        .withFieldNames(AdGroupFieldEnum.TYPE)
        );
        assertThat("AdGroups.get не вернул группу", response.getAdGroups(), hasSize(0));
    }


    @Test
    public void getGroupWithTextTypeAndTextFilter() {
        id = api.userSteps.adGroupsSteps().addGroup(adGroupAddItemMap);
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(id)
                                        .withTypes(AdGroupTypesEnum.TEXT_AD_GROUP)
                        )
                        .withFieldNames(AdGroupFieldEnum.TYPE)
        );
        assumeThat("AdGroups.get вернул одну группу", response.getAdGroups(), hasSize(1));
        assertThat("тип группы вернулся правильно",
                response.getAdGroups().get(0).getType(), equalTo(AdGroupTypesEnum.TEXT_AD_GROUP));
    }

    @Test
    public void getGroupWithTextTypeAndMobileFilter() {
        id = api.userSteps.adGroupsSteps().addGroup(adGroupAddItemMap);
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(id)
                                        .withTypes(AdGroupTypesEnum.MOBILE_APP_AD_GROUP)
                        )
                        .withFieldNames(AdGroupFieldEnum.TYPE)
        );
        assertThat("AdGroups.get не вернул группу", response.getAdGroups(), hasSize(0));
    }

    @Test
    public void getGroupWithCpmBannerTypeAndCpmBannerFilter() {
        api.userSteps.campaignFakeSteps().setType(campaignId, CampaignsType.CPM_BANNER);
        id = api.userSteps.adGroupsSteps().addGroup(adGroupAddItemMap.withCpmBannerUserProfileAdGroup());
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(id)
                                        .withTypes(AdGroupTypesEnum.CPM_BANNER_AD_GROUP)
                        )
                        .withFieldNames(AdGroupFieldEnum.TYPE)
        );
        assumeThat("AdGroups.get вернул одну группу", response.getAdGroups(), hasSize(1));
        assertThat("тип группы вернулся правильно",
                response.getAdGroups().get(0).getType(), equalTo(AdGroupTypesEnum.CPM_BANNER_AD_GROUP));
    }

    @Test
    public void getGroupWithCpmBannerTypeAndTextFilter() {
        api.userSteps.campaignFakeSteps().setType(campaignId, CampaignsType.CPM_BANNER);
        id = api.userSteps.adGroupsSteps().addGroup(adGroupAddItemMap.withCpmBannerUserProfileAdGroup());
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(id)
                                        .withTypes(AdGroupTypesEnum.TEXT_AD_GROUP)
                        )
                        .withFieldNames(AdGroupFieldEnum.TYPE)
        );
        assertThat("AdGroups.get не вернул группу", response.getAdGroups(), hasSize(0));
    }

    @Test
    public void getGroupWithCpmVideoTypeAndCpmVideoFilter() {
        api.userSteps.campaignFakeSteps().setType(campaignId, CampaignsType.CPM_BANNER);
        id = api.userSteps.adGroupsSteps().addGroup(adGroupAddItemMap.withCpmVdeoAdGroup());
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(id)
                                        .withTypes(AdGroupTypesEnum.CPM_VIDEO_AD_GROUP)
                        )
                        .withFieldNames(AdGroupFieldEnum.TYPE)
        );
        assumeThat("AdGroups.get вернул одну группу", response.getAdGroups(), hasSize(1));
        assertThat("тип группы вернулся правильно",
                response.getAdGroups().get(0).getType(), equalTo(AdGroupTypesEnum.CPM_VIDEO_AD_GROUP));
    }

    @Test
    public void getGroupWithCpmVideoTypeAndCpmBannerFilter() {
        api.userSteps.campaignFakeSteps().setType(campaignId, CampaignsType.CPM_BANNER);
        id = api.userSteps.adGroupsSteps().addGroup(adGroupAddItemMap.withCpmVdeoAdGroup());
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(id)
                                        .withTypes(AdGroupTypesEnum.CPM_BANNER_AD_GROUP)
                        )
                        .withFieldNames(AdGroupFieldEnum.TYPE)
        );
        assertThat("AdGroups.get не вернул группу", response.getAdGroups(), hasSize(0));
    }

    @Test
    public void getGroupWithMobileTypeAndMixedFilter() {
        api.userSteps.campaignFakeSteps().setType(campaignId, CampaignsType.MOBILE_CONTENT);
        id = api.userSteps.adGroupsSteps().addGroup(adGroupAddItemMap.withMobileAppAdGroup(
                new MobileAppAdGroupAddMap().defaultGroup()));
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(id)
                                        .withTypes(AdGroupTypesEnum.MOBILE_APP_AD_GROUP, AdGroupTypesEnum.TEXT_AD_GROUP)
                        )
                        .withFieldNames(AdGroupFieldEnum.TYPE)
        );
        assumeThat("AdGroups.get вернул одну группу", response.getAdGroups(), hasSize(1));
        assertThat("тип группы вернулся правильно",
                response.getAdGroups().get(0).getType(), equalTo(AdGroupTypesEnum.MOBILE_APP_AD_GROUP));
    }

    @Test
    public void getDynamicTextAdGroupByDynamicFilter() {
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(dynamicTextAdGroupId)
                                        .withTypes(AdGroupTypesEnum.DYNAMIC_TEXT_AD_GROUP)
                        )
                        .withFieldNames(AdGroupFieldEnum.ID, AdGroupFieldEnum.TYPE)
        );
        assertThat("тип группы вернулся правильно", response.getAdGroups(),
                beanDifferV5(Collections.singletonList(
                        new AdGroupGetItemMap().withId(dynamicTextAdGroupId)
                                .withType(AdGroupTypesEnum.DYNAMIC_TEXT_AD_GROUP).getBean()))
        );
    }

    @Test
    public void getDynamicTextAdGroupByTextFilter() {
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(dynamicTextAdGroupId)
                                        .withTypes(AdGroupTypesEnum.TEXT_AD_GROUP)
                        )
                        .withFieldNames(AdGroupFieldEnum.ID, AdGroupFieldEnum.TYPE)
        );
        assertThat("вернулся пустой ответ", response.getAdGroups(), hasSize(0));
    }

    @Test
    public void getDynamicTextAdGroupByMobileAppFilter() {
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(dynamicTextAdGroupId)
                                        .withTypes(AdGroupTypesEnum.MOBILE_APP_AD_GROUP)
                        )
                        .withFieldNames(AdGroupFieldEnum.ID, AdGroupFieldEnum.TYPE)
        );
        assertThat("вернулся пустой ответ", response.getAdGroups(), hasSize(0));
    }

    @Test
    public void getDynamicTextAdGroupByMixedFilter() {
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(dynamicTextAdGroupId)
                                        .withTypes(AdGroupTypesEnum.TEXT_AD_GROUP, AdGroupTypesEnum.MOBILE_APP_AD_GROUP,
                                                AdGroupTypesEnum.DYNAMIC_TEXT_AD_GROUP)
                        )
                        .withFieldNames(AdGroupFieldEnum.ID, AdGroupFieldEnum.TYPE)
        );
        assertThat("тип группы вернулся правильно", response.getAdGroups(),
                beanDifferV5(Collections.singletonList(
                        new AdGroupGetItemMap().withId(dynamicTextAdGroupId)
                                .withType(AdGroupTypesEnum.DYNAMIC_TEXT_AD_GROUP).getBean()))
        );
    }

    @Test
    public void getDynamicTextFeedAdGroupByDynamicFilter() {
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(dynamicTextFeedAdGroupId)
                                        .withTypes(AdGroupTypesEnum.DYNAMIC_TEXT_AD_GROUP)
                        )
                        .withFieldNames(AdGroupFieldEnum.ID, AdGroupFieldEnum.TYPE)
        );
        assertThat("тип группы вернулся правильно", response.getAdGroups(),
                beanDifferV5(Collections.singletonList(
                        new AdGroupGetItemMap().withId(dynamicTextFeedAdGroupId)
                                .withType(AdGroupTypesEnum.DYNAMIC_TEXT_AD_GROUP).getBean()))
        );
    }
}
