package ru.yandex.autotests.direct.api.adgroups.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.GetResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.matchers.arrays.ArraySizeMatcher;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.greaterThan;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
/**
 * Author pavryabov
 * Date 10.10.14
 * https://st.yandex-team.ru/TESTIRT-2022
 */
@Aqua.Test
@Features(AdGroupsFeatures.GET)
@Stories(AdGroupsStories.AUTHORIZATION)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class InternalRolesCheckRightsToGetTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static final String servClient = AdGroupsLogins.SERV_CLIENT;

    static Long campaignIdServ;

    @Parameterized.Parameter(0)
    public String loginForAuthorization;

    @Parameterized.Parameter(1)
    public String fakeLogin;

    @Parameterized.Parameter(2)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "loginForAuthorization = {0}, fakeLogin = {1}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {Logins.MANAGER_DEFAULT, null, ExpectedResult.success()},
                {Logins.PLACER, null, ExpectedResult.success()},
                {Logins.SUPPORT, null, ExpectedResult.success()},
                {Logins.SUPER_LOGIN, null, ExpectedResult.success()},
                {Logins.SUPER_LOGIN, servClient, ExpectedResult.success()},
                {Logins.MEDIA, null,
                        ExpectedResult.errors(new Notification(54, Api5ErrorDetails.NO_RIGHTS_TO_WRITE))},
                {Logins.SUPER_READER, null,
                        ExpectedResult.errors(new Notification(54, Api5ErrorDetails.NO_RIGHTS_TO_WRITE))}
        };
        return Arrays.asList(data);
    }

    @Before
    public void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(servClient);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(loginForAuthorization);
        campaignIdServ = api.as(Logins.MANAGER_DEFAULT).userSteps.campaignSteps().addDefaultTextCampaign(servClient);
        api.as(servClient).userSteps.adGroupsSteps().addDefaultGroup(campaignIdServ);
    }

    @Test
    public void callGet() {
        GetResponse getResponse = api.as(loginForAuthorization, fakeLogin).userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withCampaignIds(campaignIdServ)
                        )
                        .withFieldNames(AdGroupFieldEnum.CAMPAIGN_ID),
                servClient
        );
        assertThat("запрос AdGroups.get вернул группы",
                getResponse.getAdGroups().toArray(), ArraySizeMatcher.hasSize(greaterThan(0)));
    }
}
