package ru.yandex.autotests.direct.api.adgroups.get;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.GetResponse;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
/**
 * Author pavryabov
 * Date 27.08.14
 * https://st.yandex-team.ru/TESTIRT-2022
 */
@Aqua.Test
@Features(AdGroupsFeatures.GET)
public class SelectionCriteriaIgnoredObjectsTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(AdGroupsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long campaignId;
    static Long notMineCampaignId;
    static long notExistedCampaignId;
    static Long deletedCampaignId;
    static Long id;
    static Long notMineGroup;
    static Long deletedGroup;
    static Long groupFromDeletedCampaign;
    static Long notExistedGroup;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().reshardUserWithLock(AdGroupsLogins.CLIENT_SHARD2, ShardNumbers.EXTRA_SHARD);
        api.as(AdGroupsLogins.CLIENT_SHARD2);
        notMineCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdGroupsLogins.CLIENT_SHARD2);
        notMineGroup = api.userSteps.adGroupsSteps().addDefaultGroup(notMineCampaignId);
        api.as(AdGroupsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdGroupsLogins.CLIENT);
        deletedGroup = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        id = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        api.userSteps.adGroupsSteps().deleteGroup(deletedGroup);
        notExistedCampaignId = notMineCampaignId + 100000;
        notExistedGroup = deletedGroup + 100000;
        deletedCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdGroupsLogins.CLIENT);
        groupFromDeletedCampaign = api.userSteps.adGroupsSteps().addDefaultGroup(deletedCampaignId);
        api.userSteps.campaignSteps().campaignsDelete(deletedCampaignId);
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
    }

    @Test
    public void selectionCriteriaWithNotExistedCampaignId() {
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withCampaignIds(notExistedCampaignId)
                        )
                        .withFieldNames(AdGroupFieldEnum.ID)
        );
        assertThat("вернулось правильное количество групп", response.getAdGroups().size(), equalTo(0));
    }

    @Test
    public void selectionCriteriaWith0CampaignId() {
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withCampaignIds(0L)
                        )
                        .withFieldNames(AdGroupFieldEnum.ID)
        );
        assertThat("вернулось правильное количество групп", response.getAdGroups().size(), equalTo(0));
    }

    @Test
    public void selectionCriteriaWithNegativeCampaignId() {
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withCampaignIds(-campaignId)
                        )
                        .withFieldNames(AdGroupFieldEnum.ID)
        );
        assertThat("вернулось правильное количество групп", response.getAdGroups().size(), equalTo(0));
    }

    @Test
    public void selectionCriteriaWithDeletedGroup() {
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(deletedGroup)
                        )
                        .withFieldNames(AdGroupFieldEnum.ID)
        );
        assertThat("вернулось правильное количество групп", response.getAdGroups().size(), equalTo(0));
    }

    @Test
    public void selectionCriteriaWithNotExistedGroup() {
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(notExistedGroup)
                        )
                        .withFieldNames(AdGroupFieldEnum.ID)
        );
        assertThat("вернулось правильное количество групп", response.getAdGroups().size(), equalTo(0));
    }

    @Test
    public void selectionCriteriaWithZeroGroup() {
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(0L)
                        )
                        .withFieldNames(AdGroupFieldEnum.ID)
        );
        assertThat("вернулось правильное количество групп", response.getAdGroups().size(), equalTo(0));
    }

    @Test
    public void selectionCriteriaWithNegativeGroup() {
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(-id)
                        )
                        .withFieldNames(AdGroupFieldEnum.ID)
        );
        assertThat("вернулось правильное количество групп", response.getAdGroups().size(), equalTo(0));
    }

    @Test
    public void selectionCriteriaWithNotMineCampaignId() {
        //DIRECT-34620
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withCampaignIds(notMineCampaignId)
                        )
                        .withFieldNames(AdGroupFieldEnum.ID)
        );
        assertThat("вернулось правильное количество групп", response.getAdGroups().size(), equalTo(0));
    }

    @Test
    public void selectionCriteriaWithDeletedCampaignId() {
        //DIRECT-34620
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withCampaignIds(deletedCampaignId)
                        )
                        .withFieldNames(AdGroupFieldEnum.ID)
        );
        assertThat("вернулось правильное количество групп", response.getAdGroups().size(), equalTo(0));
    }

    @Test
    public void selectionCriteriaWithNotMineGroup() {
        //DIRECT-34620
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(notMineGroup)
                        )
                        .withFieldNames(AdGroupFieldEnum.ID)
        );
        assertThat("вернулось правильное количество групп", response.getAdGroups().size(), equalTo(0));
    }

    @Test
    public void selectionCriteriaWithGroupFromDeletedCampaign() {
        //DIRECT-34620
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(groupFromDeletedCampaign)
                        )
                        .withFieldNames(AdGroupFieldEnum.ID)
        );
        assertThat("вернулось правильное количество групп", response.getAdGroups().size(), equalTo(0));
    }
}
