package ru.yandex.autotests.direct.api.adgroups.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.general.StatusEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 30.05.15.
 */
@Aqua.Test
@Features(AdGroupsFeatures.GET)
@Stories(AdGroupsStories.STATUSES)
@RunWith(Parameterized.class)
public class StatusUnknownTest {

    //DIRECT-35888

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(AdGroupsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long campaignId;
    Long id;

    @Parameterized.Parameter(0)
    public String statusModerate;

    @Parameterized.Parameter(1)
    public String statusPostModerate;

    @Parameterized.Parameters(name = "statusModerate = {0}, statusPostModerate = {1}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {Status.YES, Status.NO},
                {Status.YES, Status.NEW},
                {Status.YES, Status.SENT},
                {Status.YES, Status.READY},
                {Status.YES, Status.REJECTED},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void createCampaign() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdGroupsLogins.CLIENT);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
        id = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
    }

    @Test
    public void checkStatus() {
        api.userSteps.groupFakeSteps().setStatusModerate(id, statusModerate);
        api.userSteps.groupFakeSteps().setStatusPostModerate(id, statusPostModerate);
        StatusEnum status = api.userSteps.adGroupsSteps().getGroupStatus(id);
        assertThat("вернулась группа с правильным статусом", status, equalTo(StatusEnum.UNKNOWN));
    }
}
