package ru.yandex.autotests.direct.api.adgroups.get.dynamictextadgroup;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.DynamicTextAdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.GetResponse;
import com.yandex.direct.api.v5.adgroups.SourceProcessingStatusEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdgroupsDynamicStatusblgenerated;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupGetItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.DynamicTextAdGroupGetMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by buhter on 11.12.15.
 * https://st.yandex-team.ru/TESTIRT-7965
 */
@Aqua.Test
@Features(AdGroupsFeatures.GET)
@Stories(AdGroupsStories.DYNAMIC_TEXT)
@Issue("https://st.yandex-team.ru/DIRECT-49484")
@RunWith(Parameterized.class)
public class DynamicTextAdGroupGetStatusBlGeneratedTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(AdGroupsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public AdgroupsDynamicStatusblgenerated statusBlGenerated;

    @Parameterized.Parameter(1)
    public SourceProcessingStatusEnum getStatus;

    private Long pid;
    private static int shard;

    @Parameterized.Parameters(name = "Domain URL - {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {AdgroupsDynamicStatusblgenerated.Yes, SourceProcessingStatusEnum.PROCESSED},
                {AdgroupsDynamicStatusblgenerated.No, SourceProcessingStatusEnum.EMPTY_RESULT},
                {AdgroupsDynamicStatusblgenerated.Processing, SourceProcessingStatusEnum.UNPROCESSED},
        };
        return Arrays.asList(data);
    }

    static Long campaignId;

    @BeforeClass
    public static void createCampaign() {
        shard = api.userSteps.clientFakeSteps().getUserShard(AdGroupsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdGroupsLogins.CLIENT);
        api.userSteps.campaignFakeSteps().setType(campaignId, CampaignsType.DYNAMIC);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).adgroupsDynamicSteps()
                .setStatusBlGenerated(pid, statusBlGenerated);
    }

    @Test
    public void getGroupWithDomainUrl() {
        GetResponse getResponse = api.userSteps.adGroupsSteps().adGroupsGet(new GetRequestMap()
                .withSelectionCriteria(new AdGroupsSelectionCriteriaMap().withIds(pid))
                .withFieldNames(AdGroupFieldEnum.ID)
                .withDynamicTextAdGroupFieldNames(DynamicTextAdGroupFieldEnum.DOMAIN_URL_PROCESSING_STATUS)
        );
        DynamicTextAdGroupGetMap expected = new DynamicTextAdGroupGetMap()
                .withDomainUrlProcessingStatus(getStatus);
        assertThat("вернулась правильная группа", getResponse.getAdGroups(), beanDifferV5(Collections.singletonList(
                new AdGroupGetItemMap().withId(pid).withDynamicTextAdGroup(expected).getBean())));
    }
}

