package ru.yandex.autotests.direct.api.adgroups.get.dynamictextfeedadgroup;


import java.util.Collections;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.DynamicTextFeedAdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.GetResponse;
import com.yandex.direct.api.v5.adgroups.SourceProcessingStatusEnum;
import com.yandex.direct.api.v5.adgroups.SourceTypeGetEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdgroupsDynamicStatusblgenerated;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupGetItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.DynamicTextFeedAdGroupGetMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by gerdler on 10.09.2016.
 * https://st.yandex-team.ru/TESTIRT-10035
 */
@Aqua.Test
@Features(AdGroupsFeatures.GET)
@Stories(AdGroupsStories.DYNAMIC_TEXT_FEED)
@Issue("https://st.yandex-team.ru/DIRECT-55195")
@Description("проверка получения полей относящихся к ДО-группе с фидом")
public class DynamicTextFeedAdGroupFieldNamesTest {
    private static final String LOGIN = AdGroupsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long adGroupId;
    private static Long feedId;

    @BeforeClass
    public static void initTest() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
        int shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        feedId = jooqDbSteps.feedsSteps().createDefaultFeed(User.get(LOGIN).getClientID());
        jooqDbSteps.adGroupsSteps().convertAdgroupDynamicToDynamicByFeed(adGroupId, feedId);
        assumeThat(
                "правильный статус генерации объявлений",
                jooqDbSteps.adGroupsSteps().getAdgroupsDynamic(adGroupId).getStatusblgenerated(),
                equalTo(AdgroupsDynamicStatusblgenerated.No)
        );
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
    }

    @Test
    public void fieldNamesWithOneField() {
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(adGroupId)
                        )
                        .withFieldNames(AdGroupFieldEnum.ID)
                        .withDynamicTextFeedAdGroupFieldNames(
                                DynamicTextFeedAdGroupFieldEnum.SOURCE
                        )
        );

        DynamicTextFeedAdGroupGetMap expected = new DynamicTextFeedAdGroupGetMap().withSource(feedId.toString());
        assertThat("вернулась правильная группа", response.getAdGroups(), beanDifferV5(Collections.singletonList(
                new AdGroupGetItemMap().withId(adGroupId).withDynamicTextFeedAdGroup(expected).getBean())));
    }

    @Test
    public void fieldNamesWithTwoFields() {
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(adGroupId)
                        )
                        .withFieldNames(AdGroupFieldEnum.ID)
                        .withDynamicTextFeedAdGroupFieldNames(
                                DynamicTextFeedAdGroupFieldEnum.SOURCE_TYPE,
                                DynamicTextFeedAdGroupFieldEnum.SOURCE_PROCESSING_STATUS
                        )
        );

        DynamicTextFeedAdGroupGetMap expected = new DynamicTextFeedAdGroupGetMap()
                .withSourceType(SourceTypeGetEnum.RETAIL_FEED)
                .withSourceProcessingStatus(SourceProcessingStatusEnum.EMPTY_RESULT);
        assertThat("вернулась правильная группа", response.getAdGroups(), beanDifferV5(Collections.singletonList(
                new AdGroupGetItemMap().withId(adGroupId).withDynamicTextFeedAdGroup(expected).getBean())));
    }

    @Test
    public void fieldNamesWithAllFields() {
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(adGroupId)
                        )
                        .withFieldNames(AdGroupFieldEnum.ID)
                        .withDynamicTextFeedAdGroupFieldNames(
                                DynamicTextFeedAdGroupFieldEnum.SOURCE,
                                DynamicTextFeedAdGroupFieldEnum.SOURCE_TYPE,
                                DynamicTextFeedAdGroupFieldEnum.SOURCE_PROCESSING_STATUS
                        )
        );

        DynamicTextFeedAdGroupGetMap expected = new DynamicTextFeedAdGroupGetMap().withSource(feedId.toString())
                .withSourceType(SourceTypeGetEnum.RETAIL_FEED)
                .withSourceProcessingStatus(SourceProcessingStatusEnum.EMPTY_RESULT);
        assertThat("вернулась правильная группа", response.getAdGroups(), beanDifferV5(Collections.singletonList(
                new AdGroupGetItemMap().withId(adGroupId).withDynamicTextFeedAdGroup(expected).getBean())));
    }
}
