package ru.yandex.autotests.direct.api.adgroups.get.dynamictextfeedadgroup;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.DynamicTextFeedAdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.GetResponse;
import com.yandex.direct.api.v5.adgroups.SourceProcessingStatusEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdgroupsDynamicStatusblgenerated;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupGetItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.DynamicTextFeedAdGroupGetMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by gerdler on 10.08.2016
 * https://st.yandex-team.ru/TESTIRT-10035
 */
@Aqua.Test
@Features(AdGroupsFeatures.GET)
@Stories(AdGroupsStories.DYNAMIC_TEXT_FEED)
@Issue("https://st.yandex-team.ru/DIRECT-55195")
@Description("проверка получения правильных статусов сгенерированности объявлений по фиду")
@RunWith(Parameterized.class)
public class DynamicTextFeedAdGroupGetSourceProcessingStatusTest {
    private static final String LOGIN = AdGroupsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public AdgroupsDynamicStatusblgenerated dbStatusBlGenerated;

    @Parameterized.Parameter(1)
    public SourceProcessingStatusEnum getStatus;

    private static Long campaignId;
    private static Long adGroupId;
    private static DirectJooqDbSteps jooqDbSteps;

    @Parameterized.Parameters(name = "StatusBlGenerated - {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {AdgroupsDynamicStatusblgenerated.Yes, SourceProcessingStatusEnum.PROCESSED},
                {AdgroupsDynamicStatusblgenerated.No, SourceProcessingStatusEnum.EMPTY_RESULT},
                {AdgroupsDynamicStatusblgenerated.Processing, SourceProcessingStatusEnum.UNPROCESSED},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void createCampaign() {
        int shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createAdGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
        Long feedId = jooqDbSteps.feedsSteps().createDefaultFeed(User.get(LOGIN).getClientID());
        jooqDbSteps.adGroupsSteps().convertAdgroupDynamicToDynamicByFeed(adGroupId, feedId);
        jooqDbSteps.adGroupsSteps().setAdgroupsDynamicStatusBlGenerated(adGroupId, dbStatusBlGenerated);
        assumeThat(
                "у группы правильный статус генерации объявлений",
                jooqDbSteps.adGroupsSteps().getAdgroupsDynamic(adGroupId).getStatusblgenerated(),
                equalTo(dbStatusBlGenerated)
        );
    }

    @Test
    public void getGroupWithSourceProcessingStatus() {
        GetResponse getResponse = api.userSteps.adGroupsSteps().adGroupsGet(new GetRequestMap()
                .withSelectionCriteria(new AdGroupsSelectionCriteriaMap().withIds(adGroupId))
                .withFieldNames(AdGroupFieldEnum.ID)
                .withDynamicTextFeedAdGroupFieldNames(DynamicTextFeedAdGroupFieldEnum.SOURCE_PROCESSING_STATUS)
        );
        DynamicTextFeedAdGroupGetMap expected = new DynamicTextFeedAdGroupGetMap()
                .withSourceProcessingStatus(getStatus);
        assertThat("вернулся правильный статус генерации объявлений", getResponse.getAdGroups(), beanDifferV5(
                Collections.singletonList(
                        new AdGroupGetItemMap().withId(adGroupId).withDynamicTextFeedAdGroup(expected).getBean())));
    }
}

