package ru.yandex.autotests.direct.api.adgroups.get.mobileappadgroup;


import java.util.Collections;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.GetResponse;
import com.yandex.direct.api.v5.adgroups.MobileAppAdGroupFieldEnum;
import com.yandex.direct.api.v5.general.StatusEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.MobileContentStatusiconmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdgroupsMobileContentRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.MobileContentRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupGetItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.MobileAppAdGroupAddMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.MobileAppAdGroupGetMap;
import ru.yandex.autotests.directapi.model.api5.general.ExtensionModerationMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Author buhter
 * Date 17.09.15
 * https://st.yandex-team.ru/TESTIRT-7178
 */
@Aqua.Test
@Features(AdGroupsFeatures.GET)
@Stories(AdGroupsStories.MOBILE)
@Tag(TagDictionary.TRUNK)
@Issue("https://st.yandex-team.ru/DIRECT-44780")
public class MobileAppAdGroupFieldNamesTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdGroupsLogins.CLIENT);
    private static DirectJooqDbSteps jooqDbSteps;

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long id;

    @BeforeClass
    public static void initTest() {
        Integer campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign().intValue();
        id = api.userSteps.adGroupsSteps().addGroup(
                new AdGroupAddItemMap()
                        .defaultAdGroupAddItem(campaignId.longValue())
                        .withMobileAppAdGroup(new MobileAppAdGroupAddMap().defaultGroup())
        );
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(AdGroupsLogins.CLIENT);

        AdgroupsMobileContentRecord adgroupsMobileContent = jooqDbSteps.adGroupsSteps().getAdGroupMobileContent(id);
        MobileContentRecord mobileContent = jooqDbSteps.mobileContentSteps().getMobileContent(adgroupsMobileContent.getMobileContentId());

        mobileContent.setIconHash("32453/dvwdsvwfwgwg");
        mobileContent.setStatusiconmoderate(MobileContentStatusiconmoderate.Yes);
        jooqDbSteps.mobileContentSteps().updateMobileContent(mobileContent);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void init() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
    }

    @Test
    public void fieldNamesWithTwoFields() {
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(id)
                        )
                        .withFieldNames(AdGroupFieldEnum.ID)
                        .withMobileAppAdGroupFieldNames(
                                MobileAppAdGroupFieldEnum.STORE_URL
                                , MobileAppAdGroupFieldEnum.TARGET_DEVICE_TYPE
                        )
        );

        MobileAppAdGroupGetMap expected = new MobileAppAdGroupGetMap()
                .withStoreUrl(MobileAppAdGroupAddMap.DEFAULT_STORE_URL)
                .withTargetDeviceTypes(MobileAppAdGroupAddMap.DEFAULT_TARGET_DEVICE_TYPE);
        assertThat("вернулась правильная группа", response.getAdGroups(), beanDifferV5(Collections.singletonList(
                new AdGroupGetItemMap().withId(id).withMobileAppAdGroup(expected).getBean())));
    }

    @Test
    public void fieldNamesWithAllFields() {
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(id)
                        )
                        .withFieldNames(
                                AdGroupFieldEnum.ID
                        )
                        .withMobileAppAdGroupFieldNames(
                                MobileAppAdGroupFieldEnum.TARGET_CARRIER
                                , MobileAppAdGroupFieldEnum.TARGET_DEVICE_TYPE
                                , MobileAppAdGroupFieldEnum.TARGET_OPERATING_SYSTEM_VERSION
                                , MobileAppAdGroupFieldEnum.STORE_URL
                                , MobileAppAdGroupFieldEnum.APP_ICON_MODERATION
                        )
        );
        MobileAppAdGroupGetMap expected = new MobileAppAdGroupGetMap()
                .withStoreUrl(MobileAppAdGroupAddMap.DEFAULT_STORE_URL)
                .withTargetDeviceTypes(MobileAppAdGroupAddMap.DEFAULT_TARGET_DEVICE_TYPE)
                .withTargetCarrier(MobileAppAdGroupAddMap.DEFAULT_TARGET_CARRIER)
                .withTargetOperatingSystemVersion(MobileAppAdGroupAddMap.DEFAULT_TARGET_OPERATING_SYSTEM_VERSION)
                .withAppIconModeration(new ExtensionModerationMap()
                        .withStatusClarification("")
                        .withStatus(StatusEnum.ACCEPTED));
        assertThat("вернулась правильная группа", response.getAdGroups()
                , beanDifferV5(Collections.singletonList(
                        new AdGroupGetItemMap().withId(id).withMobileAppAdGroup(expected).getBean()))
        );
    }
}
