package ru.yandex.autotests.direct.api.adgroups.get.mobileappadgroup;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.AdGroupGetItem;
import com.yandex.direct.api.v5.adgroups.AppAvailabilityStatusEnum;
import com.yandex.direct.api.v5.adgroups.GetResponse;
import com.yandex.direct.api.v5.adgroups.MobileAppAdGroupFieldEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdgroupsMobileContentRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.MobileContentRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupGetItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.MobileAppAdGroupGetMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;

/**
 * Created by semkagtn on 21.10.15.
 * https://st.yandex-team.ru/TESTIRT-7521
 */
@Aqua.Test
@Features(AdGroupsFeatures.GET)
@Issue("https://st.yandex-team.ru/DIRECT-47355")
@Description("Возвращение поля AppAvailabilityStatus методом AdGroups.get")
@RunWith(Parameterized.class)
public class MobileAppAdGroupGetAppAvailabilityStatusTypeTest {

    private static final String LOGIN = AdGroupsLogins.CLIENT;

    //private static final String ZERO_MODIFY_TIME = "0000-00-00 00:00:00";
    private static final Timestamp NON_ZERO_MODIFY_TIME = new Timestamp(System.currentTimeMillis());

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);
    private static DirectJooqDbSteps jooqDbSteps;

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public Timestamp modifyTime;

    // значение может быть только 1 или 0
    @Parameterized.Parameter(1)
    public int isAvailable;

    @Parameterized.Parameter(2)
    public AppAvailabilityStatusEnum expectedStatus;

    @Parameterized.Parameters(name = "modify_time = {0}, is_available = {1}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                //{ZERO_MODIFY_TIME, 0, AppAvailabilityStatusEnum.UNPROCESSED},
                //{ZERO_MODIFY_TIME, 1, AppAvailabilityStatusEnum.UNPROCESSED},
                {NON_ZERO_MODIFY_TIME, 0, AppAvailabilityStatusEnum.NOT_AVAILABLE},
                {NON_ZERO_MODIFY_TIME, 1, AppAvailabilityStatusEnum.AVAILABLE},
        });
    }

    private static MobileContentRecord mobileContent;
    private static long adGroupId;

    @BeforeClass
    public static void prepareStaticData() {
        long campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup((int) campaignId);

        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN);
        AdgroupsMobileContentRecord adgroupsMobileContent = jooqDbSteps.adGroupsSteps().getAdGroupMobileContent(adGroupId);
        mobileContent = jooqDbSteps.mobileContentSteps().getMobileContent(adgroupsMobileContent.getMobileContentId());
    }

    @Before
    @Step("Подготовка данных для теста")
    public void prepareData() {
        mobileContent.setModifyTime(modifyTime);
        mobileContent.setIsAvailable(isAvailable);
        jooqDbSteps.mobileContentSteps().updateMobileContent(mobileContent);
    }

    @Test
    public void getAppAvailabilityStatusType() {
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(new GetRequestMap()
                .withFieldNames(AdGroupFieldEnum.ID)
                .withMobileAppAdGroupFieldNames(MobileAppAdGroupFieldEnum.APP_AVAILABILITY_STATUS)
                .withSelectionCriteria(new AdGroupsSelectionCriteriaMap()
                        .withIds(adGroupId)));
        List<AdGroupGetItem> actualResult = response.getAdGroups();

        assertThat("вернулся верный статус доступности приложения",
                actualResult, beanEquivalent(Collections.singletonList(new AdGroupGetItemMap()
                        .withMobileAppAdGroup(new MobileAppAdGroupGetMap()
                                .withAppAvailabilityStatus(expectedStatus)).getBean())));
    }
}