package ru.yandex.autotests.direct.api.adgroups.get.mobileappadgroup;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.GetResponse;
import com.yandex.direct.api.v5.adgroups.MobileAppAdGroupFieldEnum;
import com.yandex.direct.api.v5.general.StatusEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.MobileContentStatusiconmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdgroupsMobileContentRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.MobileContentRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.MobileAppAdGroupAddMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.MobileAppAdGroupGetMap;
import ru.yandex.autotests.directapi.model.api5.general.ExtensionModerationMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.iterableWithSize;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Author buhter
 * Date 17.09.15
 * https://st.yandex-team.ru/TESTIRT-7178
 */
@Aqua.Test
@Features(AdGroupsFeatures.GET)
@Stories(AdGroupsStories.MOBILE)
@Tag(TagDictionary.TRUNK)
@Issue("https://st.yandex-team.ru/DIRECT-44780")
@RunWith(Parameterized.class)
public class MobileAppAdGroupGetAppIconModerationTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(AdGroupsLogins.CLIENT);
    private static DirectJooqDbSteps jooqDbSteps;

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static MobileContentRecord mobileContent;

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public MobileContentStatusiconmoderate statusInDB;

    @Parameterized.Parameter(1)
    public StatusEnum expectedStatus;

    @Parameterized.Parameters()
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {MobileContentStatusiconmoderate.No, StatusEnum.REJECTED},
                {MobileContentStatusiconmoderate.Ready, StatusEnum.MODERATION},
                {MobileContentStatusiconmoderate.Sent, StatusEnum.MODERATION},
                {MobileContentStatusiconmoderate.Sending, StatusEnum.MODERATION},
                {MobileContentStatusiconmoderate.Yes, StatusEnum.ACCEPTED}
        };
        return Arrays.asList(data);
    }

    static Integer campaignId;
    static Long id;

    @BeforeClass
    public static void createCampaign() {
        campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign().intValue();
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
        id = api.userSteps.adGroupsSteps().addGroup(new AdGroupAddItemMap()
                .defaultAdGroupAddItem(Long.valueOf(campaignId))
                .withMobileAppAdGroup(new MobileAppAdGroupAddMap().defaultGroup())
        );
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(AdGroupsLogins.CLIENT);

        AdgroupsMobileContentRecord adgroupsMobileContent = jooqDbSteps.adGroupsSteps()
                .getAdGroupMobileContent(id);
        mobileContent = jooqDbSteps.mobileContentSteps().getMobileContent(adgroupsMobileContent.getMobileContentId());

        mobileContent.setIconHash("32453/dvwdsvwfwgwg");
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createGroup() {
        mobileContent.setStatusiconmoderate(statusInDB);
        jooqDbSteps.mobileContentSteps().updateMobileContent(mobileContent);
    }

    @Test
    public void getGroupWithAppIconModeration() {
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(id)
                        )
                        .withFieldNames(AdGroupFieldEnum.ID)
                        .withMobileAppAdGroupFieldNames(MobileAppAdGroupFieldEnum.APP_ICON_MODERATION)
        );
        assumeThat("вернулась одна группа", response.getAdGroups(), iterableWithSize(1));
        assertThat("вернулась правильная группа", response.getAdGroups().get(0).getMobileAppAdGroup(),
                beanDifferV5(new MobileAppAdGroupGetMap().withAppIconModeration(new ExtensionModerationMap()
                        .withStatusClarification("")
                        .withStatus(expectedStatus)
                ).getBean()));
    }
}
