package ru.yandex.autotests.direct.api.adgroups.get.mobileappadgroup;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import com.yandex.direct.api.v5.adgroups.AdGroupAppIconStatusSelectionEnum;
import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.AdGroupGetItem;
import com.yandex.direct.api.v5.adgroups.GetResponse;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.MobileContentStatusiconmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdgroupsMobileContentRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.MobileContentRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupGetItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.MobileAppAdGroupAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.banners.AdGroupsSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.contains;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.directapi.model.api5.adgroups.MobileAppAdGroupAddMap.ANDROID_STORE_URL;
import static ru.yandex.autotests.directapi.model.api5.adgroups.MobileAppAdGroupAddMap.IOS_STORE_URL;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Author buhter
 * Date 20.11.15
 * https://st.yandex-team.ru/TESTIRT-7178
 */
@Aqua.Test
@Features(AdGroupsFeatures.GET)
@Stories(AdGroupsStories.MOBILE)
@Issue("https://st.yandex-team.ru/DIRECT-44780")
public class MobileAppAdGroupGetAppIconStatusesFilterTest {
    
    private static final String CLIENT = AdGroupsLogins.SERV_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);
    private static DirectJooqDbSteps jooqDbSteps;

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long firstMobileCampaignId;
    private static Long secondMobileCampaignId;
    private static Long textCampaignId;
    private static Long secondAdGroupId;
    private static Long firstAdGroupId;
    private static Long textAdGroupId;

    private static AdGroupsSteps adGroupsSteps;

    private MobileContentRecord firstMobileContent;
    private MobileContentRecord secondMobileContent;

    @BeforeClass
    public static void initTest() {
        adGroupsSteps = api.userSteps.adGroupsSteps();
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(AdGroupsLogins.CLIENT);

        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        textCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
        firstMobileCampaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign(CLIENT);
        secondMobileCampaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign(CLIENT);

        textAdGroupId = adGroupsSteps.addDefaultGroup(textCampaignId);
        AdGroupAddItemMap parameters = new AdGroupAddItemMap().defaultAdGroupAddItem(firstMobileCampaignId)
                .withMobileAppAdGroup(new MobileAppAdGroupAddMap().defaultGroup().withStoreUrl(ANDROID_STORE_URL));
        firstAdGroupId = adGroupsSteps.addGroup(parameters);
        parameters = new AdGroupAddItemMap().defaultAdGroupAddItem(secondMobileCampaignId)
                .withMobileAppAdGroup(new MobileAppAdGroupAddMap().defaultGroup().withStoreUrl(IOS_STORE_URL));
        secondAdGroupId = adGroupsSteps.addGroup(parameters);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void before() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);

        AdgroupsMobileContentRecord adgroupsMobileContent = jooqDbSteps.adGroupsSteps().getAdGroupMobileContent(firstAdGroupId);
        firstMobileContent = jooqDbSteps.mobileContentSteps().getMobileContent(adgroupsMobileContent.getMobileContentId());
        firstMobileContent.setIconHash("32453/dvwdsvwfwgwg");
        firstMobileContent.setStatusiconmoderate(MobileContentStatusiconmoderate.No);
        firstMobileContent.setPublisherDomainId(null);
        jooqDbSteps.mobileContentSteps().updateMobileContent(firstMobileContent);

        adgroupsMobileContent = jooqDbSteps.adGroupsSteps().getAdGroupMobileContent(secondAdGroupId);
        secondMobileContent = jooqDbSteps.mobileContentSteps().getMobileContent(adgroupsMobileContent.getMobileContentId());
        secondMobileContent.setIconHash("312567/zcvbseafgrsfd");
        secondMobileContent.setPublisherDomainId(null);
        firstMobileContent.setStatusiconmoderate(MobileContentStatusiconmoderate.No);
        jooqDbSteps.mobileContentSteps().updateMobileContent(secondMobileContent);
    }

    @Test
    public void testGetGroupWithAppIconStatusesFilter() {
        secondMobileContent.setStatusiconmoderate(MobileContentStatusiconmoderate.No);
        jooqDbSteps.mobileContentSteps().updateMobileContent(secondMobileContent);
        GetResponse response = adGroupsSteps.adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withCampaignIds(firstMobileCampaignId, secondMobileCampaignId, textCampaignId)
                                        .withAppIconStatuses(AdGroupAppIconStatusSelectionEnum.REJECTED)
                        )
                        .withFieldNames(AdGroupFieldEnum.ID)
        );
        List<Long> gotIds = response.getAdGroups().stream()
                .map(AdGroupGetItem::getId)
                .sorted()
                .collect(Collectors.toList());
        assertThat("AdGroups.get вернул правильный набор групп", gotIds, equalTo(
                Stream.of(firstAdGroupId, secondAdGroupId).sorted().collect(Collectors.toList())));
    }

    @Test
    public void testGetGroupWithAppIconStatusesFilter1() {
        secondMobileContent.setStatusiconmoderate(MobileContentStatusiconmoderate.Yes);
        jooqDbSteps.mobileContentSteps().updateMobileContent(secondMobileContent);
        GetResponse response = adGroupsSteps.adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withCampaignIds(firstMobileCampaignId, secondMobileCampaignId, textCampaignId)
                                        .withAppIconStatuses(AdGroupAppIconStatusSelectionEnum.ACCEPTED)
                        )
                        .withFieldNames(AdGroupFieldEnum.ID)
        );
        assertThat("AdGroups.get вернул правильный набор групп", response.getAdGroups(),
                contains(
                        beanEquals(new AdGroupGetItemMap().withId(secondAdGroupId).getBean()))
        );
    }


    @Test
    public void testGetGroupWithAppIconStatusesFilter2() {
        secondMobileContent.setStatusiconmoderate(MobileContentStatusiconmoderate.Sent);
        jooqDbSteps.mobileContentSteps().updateMobileContent(secondMobileContent);
        GetResponse response = adGroupsSteps.adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withCampaignIds(firstMobileCampaignId, secondMobileCampaignId, textCampaignId)
                                        .withAppIconStatuses(AdGroupAppIconStatusSelectionEnum.MODERATION)
                        )
                        .withFieldNames(AdGroupFieldEnum.ID)
        );
        assertThat("AdGroups.get вернул правильный набор групп", response.getAdGroups(),
                contains(
                        beanEquals(new AdGroupGetItemMap().withId(secondAdGroupId).getBean()))
        );
    }

    @Test
    public void testGetGroupWithNoAppIconStatusesFilter() {
        GetResponse response = adGroupsSteps.adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withCampaignIds(firstMobileCampaignId, secondMobileCampaignId, textCampaignId)
                        )
                        .withFieldNames(AdGroupFieldEnum.ID)
        );
        List<Long> gotIds = response.getAdGroups().stream().map(AdGroupGetItem::getId).sorted().collect(Collectors.toList());
        assertThat("AdGroups.get вернул правильный набор групп",
                gotIds,
                equalTo(Stream.of(firstAdGroupId, secondAdGroupId, textAdGroupId).sorted().collect(Collectors.toList())));
    }
}
