package ru.yandex.autotests.direct.api.adgroups.get.mobileappadgroup;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.AdGroupGetItem;
import com.yandex.direct.api.v5.adgroups.GetResponse;
import com.yandex.direct.api.v5.adgroups.MobileAppAdGroupFieldEnum;
import com.yandex.direct.api.v5.general.MobileOperatingSystemTypeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupGetItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.MobileAppAdGroupAddMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.MobileAppAdGroupGetMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;

/**
 * Created by semkagtn on 21.10.15.
 * https://st.yandex-team.ru/TESTIRT-7521
 */
@Aqua.Test
@Features(AdGroupsFeatures.GET)
@Issue("https://st.yandex-team.ru/DIRECT-47355")
@Description("Возвращение поля OperatingSystemType методом AdGroups.get")
@RunWith(Parameterized.class)
public class MobileAppAdGroupGetOperatingSystemTypeTest {

    private static final String LOGIN = AdGroupsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String storeUrl;

    @Parameterized.Parameter(1)
    public MobileOperatingSystemTypeEnum expectedOperatingSystemType;

    @Parameterized.Parameters(name = "storeUrl = {0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {MobileAppAdGroupAddMap.ANDROID_STORE_URL,
                        MobileOperatingSystemTypeEnum.ANDROID},
                {MobileAppAdGroupAddMap.IOS_STORE_URL,
                        MobileOperatingSystemTypeEnum.IOS}
        });
    }

    private long adGroupId;

    @Before
    @Step("Подготовка данных для теста")
    public void prepareData() {
        long campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addGroup(new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId)
                .withMobileAppAdGroup(
                        new MobileAppAdGroupAddMap().defaultGroup().withStoreUrl(storeUrl)));
    }

    @Test
    public void getAppAvailabilityStatusType() {
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(new GetRequestMap()
                .withFieldNames(AdGroupFieldEnum.ID)
                .withMobileAppAdGroupFieldNames(MobileAppAdGroupFieldEnum.APP_OPERATING_SYSTEM_TYPE)
                .withSelectionCriteria(new AdGroupsSelectionCriteriaMap()
                        .withIds(adGroupId)));
        List<AdGroupGetItem> actualResult = response.getAdGroups();

        assertThat("вернулась верная версия операционной системы",
                actualResult, beanEquivalent(Collections.singletonList(new AdGroupGetItemMap()
                        .withMobileAppAdGroup(new MobileAppAdGroupGetMap()
                                .withAppOperatingSystemType(expectedOperatingSystemType)).getBean())));
    }
}
