package ru.yandex.autotests.direct.api.adgroups.get.mobileappadgroup;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.GetResponse;
import com.yandex.direct.api.v5.adgroups.MobileAppAdGroupFieldEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.MobileAppAdGroupAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Author buhter
 * Date 17.09.15
 * https://st.yandex-team.ru/TESTIRT-7178
 */
@Aqua.Test
@Features(AdGroupsFeatures.GET)
@Stories(AdGroupsStories.MOBILE)
@Tag(TagDictionary.TRUNK)
@Issue("https://st.yandex-team.ru/DIRECT-44780")
@RunWith(Parameterized.class)
public class MobileAppAdGroupGetStoreUrlTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(AdGroupsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String storeUrl;

    @Parameterized.Parameters(name = "StoreUrl = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {"https://play.google.com/store/apps/details?id=ru.yandex.searchplugin"},
                {"http://play.google.com/store/apps/details?id=ru.yandex.searchplugin"},
                {"https://itunes.apple.com/ru/app/id343200656?mt=8"},
                {"http://itunes.apple.com/ru/app/id343200656?mt=8"}
        };
        return Arrays.asList(data);
    }

    private Long id;

    @Before
    @Step("Подготовка данных для теста")
    public void createGroup() {
        long campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        MobileAppAdGroupAddMap mobileAppAdGroupAdd = new MobileAppAdGroupAddMap().defaultGroup();
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
        id = api.userSteps.adGroupsSteps().addGroup(new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId)
                .withMobileAppAdGroup(mobileAppAdGroupAdd.withStoreUrl(storeUrl)));
    }

    @Test
    public void getGroupWithStoreUrl() {
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(id)
                        )
                        .withFieldNames(AdGroupFieldEnum.NAME)
                        .withMobileAppAdGroupFieldNames(MobileAppAdGroupFieldEnum.STORE_URL)
        );
        assumeThat("AdGroups.get вернул одну группу", response.getAdGroups(), hasSize(1));
        assertThat("ссылка на мобильное приложение группы вернулась правильно"
                , response.getAdGroups().get(0).getMobileAppAdGroup().getStoreUrl()
                , equalTo(storeUrl));
    }
}
