package ru.yandex.autotests.direct.api.adgroups.get.mobileappadgroup;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.GetResponse;
import com.yandex.direct.api.v5.adgroups.MobileAppAdGroupFieldEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.bslogs.mobile.OSVersions;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.MobileAppAdGroupAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Author buhter
 * Date 17.09.15
 * https://st.yandex-team.ru/TESTIRT-7178
 */
@Aqua.Test
@Features(AdGroupsFeatures.GET)
@Stories(AdGroupsStories.MOBILE)
@Tag(TagDictionary.TRUNK)
@Issue("https://st.yandex-team.ru/DIRECT-44780")
@RunWith(Parameterized.class)
public class MobileAppAdGroupGetTargetOperatingSystemVersionTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(AdGroupsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String osVersion;

    @Parameterized.Parameter(1)
    public String storeUrl;

    @Parameterized.Parameters()
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {OSVersions.IOS_VERSIONS[1], MobileAppAdGroupAddMap.IOS_STORE_URL},
                {OSVersions.ANDRIOD_VERSIONS[1], MobileAppAdGroupAddMap.ANDROID_STORE_URL},
                {OSVersions.IOS_VERSIONS[OSVersions.IOS_VERSIONS.length - 1], MobileAppAdGroupAddMap.IOS_STORE_URL},
                {OSVersions.ANDRIOD_VERSIONS[OSVersions.ANDRIOD_VERSIONS.length - 1], MobileAppAdGroupAddMap.ANDROID_STORE_URL}
        };
        return Arrays.asList(data);
    }

    private Long id;

    @Before
    @Step("Подготовка данных для теста")
    public void createGroup() {
        long campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
        MobileAppAdGroupAddMap mobileAppAdGroupAdd = new MobileAppAdGroupAddMap().defaultGroup().withStoreUrl(storeUrl);
        id = api.userSteps.adGroupsSteps().addGroup(new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId)
                .withMobileAppAdGroup(mobileAppAdGroupAdd.withTargetOperatingSystemVersion(osVersion)));
    }

    @Test
    public void getGroupWithTargetOperatingSystemVersion() {
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(id)
                        )
                        .withFieldNames(AdGroupFieldEnum.NAME)
                        .withMobileAppAdGroupFieldNames(MobileAppAdGroupFieldEnum.TARGET_OPERATING_SYSTEM_VERSION)
        );
        assumeThat("AdGroups.get вернул одну группу", response.getAdGroups(), hasSize(1));
        assertThat("TargetCarrier группы вернулось правильно"
                , response.getAdGroups().get(0).getMobileAppAdGroup().getTargetOperatingSystemVersion()
                , equalTo(osVersion));
    }
}
