package ru.yandex.autotests.direct.api.adgroups.get.mobileappadgroup;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.general.StatusEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Author buhter
 * Date 20.11.15
 * https://st.yandex-team.ru/TESTIRT-7178
 */
@Aqua.Test
@Features(AdGroupsFeatures.GET)
@Stories(AdGroupsStories.MOBILE)
@RunWith(Parameterized.class)
public class MobileAppAdGroupsStatusesTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdGroupsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Integer campaignId;
    Long id;

    @Parameterized.Parameter(0)
    public String statusModerate;

    @Parameterized.Parameter(1)
    public String statusPostModerate;

    @Parameterized.Parameter(2)
    public StatusEnum expectedStatus;


    @Parameterized.Parameters(name = "statusModerate = {0}, statusPostModerate = {1}, expectedOperatingSystemType = {2}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {Status.NO, Status.YES, StatusEnum.REJECTED},
                {Status.NO, Status.NO, StatusEnum.REJECTED},
                {Status.NO, Status.NEW, StatusEnum.REJECTED},
                {Status.NO, Status.SENT, StatusEnum.REJECTED},
                {Status.NO, Status.REJECTED, StatusEnum.REJECTED},
                {Status.NO, Status.READY, StatusEnum.REJECTED},
                {Status.NEW, Status.YES, StatusEnum.DRAFT},
                {Status.NEW, Status.NO, StatusEnum.DRAFT},
                {Status.NEW, Status.NEW, StatusEnum.DRAFT},
                {Status.NEW, Status.SENT, StatusEnum.DRAFT},
                {Status.NEW, Status.REJECTED, StatusEnum.DRAFT},
                {Status.NEW, Status.READY, StatusEnum.DRAFT},
                {Status.SENDING, Status.REJECTED, StatusEnum.MODERATION},
                {Status.SENDING, Status.NO, StatusEnum.MODERATION},
                {Status.SENDING, Status.YES, StatusEnum.PREACCEPTED},
                {Status.SENDING, Status.NEW, StatusEnum.MODERATION},
                {Status.SENDING, Status.SENT, StatusEnum.MODERATION},
                {Status.SENDING, Status.READY, StatusEnum.MODERATION},
                {Status.SENT, Status.NO, StatusEnum.MODERATION},
                {Status.SENT, Status.YES, StatusEnum.PREACCEPTED},
                {Status.SENT, Status.NEW, StatusEnum.MODERATION},
                {Status.SENT, Status.SENT, StatusEnum.MODERATION},
                {Status.SENT, Status.READY, StatusEnum.MODERATION},
                {Status.SENT, Status.REJECTED, StatusEnum.MODERATION},
                {Status.READY, Status.NO, StatusEnum.MODERATION},
                {Status.READY, Status.YES, StatusEnum.PREACCEPTED},
                {Status.READY, Status.REJECTED, StatusEnum.MODERATION},
                {Status.READY, Status.NEW, StatusEnum.MODERATION},
                {Status.READY, Status.SENT, StatusEnum.MODERATION},
                {Status.READY, Status.READY, StatusEnum.MODERATION},
                {Status.YES, Status.YES, StatusEnum.ACCEPTED},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void createCampaign() {
        campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign().intValue();
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
        id = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
    }

    @Test
    public void checkStatus() {
        api.userSteps.groupFakeSteps().setStatusModerate(id, statusModerate);
        api.userSteps.groupFakeSteps().setStatusPostModerate(id, statusPostModerate);
        StatusEnum status = api.userSteps.adGroupsSteps().getGroupStatus(id);
        assertThat("вернулась группа с правильным статусом", status, equalTo(expectedStatus));
    }
}
