package ru.yandex.autotests.direct.api.adgroups.get.negativekeywords;

import java.util.Collection;
import java.util.List;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.GetResponse;
import com.yandex.direct.api.v5.general.ArrayOfString;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Arrays.asList;
import static java.util.Collections.singletonList;
import static org.hamcrest.Matchers.contains;
import static org.hamcrest.Matchers.either;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasProperty;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.is;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Author pavryabov
 * Date 26.08.14
 * https://st.yandex-team.ru/TESTIRT-2022
 */
@Aqua.Test
@Features(AdGroupsFeatures.GET)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class GetNegativeKeywordsSemanticTest {

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(AdGroupsLogins.CLIENT);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @SuppressWarnings("DefaultAnnotationParam")
    @Parameterized.Parameter(0)
    public List<String> negativeKeywords;

    @Parameterized.Parameter(1)
    public Matcher<List<String>> negativeKeywordsAfterSaveMatcher;

    @Parameterized.Parameters(name = "{0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {asList(AdGroupAddItemMap.DEFAULT_NEGATIVE_KEYWORD, "кондиционеры"),
                        contains("кондиционеры", AdGroupAddItemMap.DEFAULT_NEGATIVE_KEYWORD)},
                {singletonList("транзитом"),
                        contains("транзитом")},
                {asList("арбуз", "арбузов"),
                        // TODO DIRECT-75345
                        contains(either(equalTo("арбуз")).or(equalTo("арбузов")))},
                {asList("апельсинов", "апельсины", "апельсин"),
                        contains("апельсинов")},
                {asList("предлагать", "предлагаемый"),
                        contains("предлагать")},
                {asList("яблочная", "яблочного", "стробоскопу", "стробоскоп", "яблоко", "яблочный"),
                        contains("стробоскопу", "яблоко", "яблочная")}
        };
        return asList(data);
    }

    private static AdGroupAddItemMap adGroupAddItemMap;
    private Long id;

    @BeforeClass
    public static void createCampaign() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdGroupsLogins.CLIENT);
        adGroupAddItemMap = new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
        id = api.userSteps.adGroupsSteps().addGroup(
                adGroupAddItemMap.withNegativeKeywords(negativeKeywords.toArray(new String[]{})));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1737")
    public void getGroupWithNegativeKeywords() {
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(id)
                        )
                        .withFieldNames(AdGroupFieldEnum.NEGATIVE_KEYWORDS)
        );
        assumeThat("AdGroups.get вернул одну группу", response.getAdGroups(), hasSize(1));
        JAXBElement<ArrayOfString> negativeKeywordsAfterSave = response.getAdGroups().get(0).getNegativeKeywords();
        assumeThat("в ответе есть минус-слова", negativeKeywordsAfterSave.isNil(), is(false));
        assertThat("минус-слова сохранились правильно",
                negativeKeywordsAfterSave,
                hasProperty("value", hasProperty("items", negativeKeywordsAfterSaveMatcher)));
    }
}
