package ru.yandex.autotests.direct.api.adgroups.get.negativekeywords;


import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.GetResponse;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.banners.KeywordsSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.either;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Author pavryabov
 * Date 26.08.14
 * https://st.yandex-team.ru/TESTIRT-2022
 */
@Aqua.Test
@Features(AdGroupsFeatures.GET)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class GetNegativeKeywordsTest {

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(AdGroupsLogins.CLIENT);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @SuppressWarnings("DefaultAnnotationParam")
    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String[] negativeKeywords;

    @Parameterized.Parameter(2)
    public String[] negativeKeywordsAfterSavePerl;

    @Parameterized.Parameter(3)
    public String[] negativeKeywordsAfterSaveJava;

    @Parameterized.Parameters(name = "{0}")
    public static Collection testData() {
        String maxLengthNegativeKeyword =
                RandomStringUtils.randomAlphabetic(KeywordsSteps.MINUS_WORD_MAX_LENGTH);
        String[] noJava = {};

        @SuppressWarnings("squid:S1192")
        Object[][] data = new Object[][]{
                {"One russian keyword", new String[]{"подарки"}, new String[]{"подарки"}, noJava},
                {"One english keyword", new String[]{"english"}, new String[]{"english"}, noJava},
                {"One keyword with maximum length",
                        new String[]{maxLengthNegativeKeyword},
                        new String[]{maxLengthNegativeKeyword.toLowerCase()},
                        new String[]{maxLengthNegativeKeyword}},
                {"+test", new String[]{"+test"}, new String[]{"+test"}, noJava},
                {"!test", new String[]{"!test"}, new String[]{"!test"}, noJava},
                {"te.st", new String[]{"te.st"}, new String[]{"te st"}, noJava},
                {"test.", new String[]{"test."}, new String[]{"test"}, noJava},
                {"1test", new String[]{"1test"}, new String[]{"1test"}, noJava},
                {"te1st", new String[]{"te1st"}, new String[]{"te1st"}, noJava},
                {"test1", new String[]{"test1"}, new String[]{"test1"}, noJava},
                {" test", new String[]{" test"}, new String[]{"test"}, noJava},
                {"test ", new String[]{"test "}, new String[]{"test"}, noJava}
        };
        return Arrays.asList(data);
    }

    private static AdGroupAddItemMap adGroupAddItemMap;
    private Long id;

    @BeforeClass
    public static void createCampaign() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdGroupsLogins.CLIENT);
        adGroupAddItemMap = new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
        id = api.userSteps.adGroupsSteps().addGroup(adGroupAddItemMap.withNegativeKeywords(negativeKeywords));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1738")
    public void getGroupWithNegativeKeywords() {
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(id)
                        )
                        .withFieldNames(AdGroupFieldEnum.NEGATIVE_KEYWORDS)
        );
        assumeThat("AdGroups.get вернул одну группу", response.getAdGroups(), hasSize(1));
        assertThat("минус-слова вернулись правильно",
                response.getAdGroups().get(0).getNegativeKeywords().getValue().getItems(),
                either(equalTo(Arrays.asList(negativeKeywordsAfterSavePerl)))
                        .or(equalTo(Arrays.asList(negativeKeywordsAfterSaveJava))));
    }
}
