package ru.yandex.autotests.direct.api.adgroups.get.textadgroupfeedparams;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.GetResponse;
import com.yandex.direct.api.v5.adgroups.TextAdGroupFeedParamsFieldEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupGetItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.MobileAppAdGroupAddMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.MobileAppAdGroupGetMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Author pashkus
 * Date 23.09.21
 */
@Aqua.Test
@Features(AdGroupsFeatures.GET)
@Stories(AdGroupsStories.MOBILE)
@Tag(TagDictionary.TRUNK)
@Issue("https://st.yandex-team.ru/DIRECT-147863")
public class TextAdGroupFeedParamsGetTest {

    private static final String client = AdGroupsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);
    private static DirectJooqDbSteps jooqDbSteps;

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long adGroupId;
    private static Long adGroupIdWithFeed;
    private static Long feedId;
    private static List<Long> feedCategoryIds = Arrays.asList(1L, 2L, 3L);

    @BeforeClass
    public static void initTest() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();

        int shard = api.userSteps.clientFakeSteps().getUserShard(client);
        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        feedId = jooqDbSteps.feedsSteps().createDefaultFeed(User.get(client).getClientID());

        jooqDbSteps.featuresSteps().setClientFeature(
                Long.valueOf(User.get(client).getClientID()),
                "allow_use_feeds_in_tgo_groups",
                true);

        adGroupId = api.userSteps.adGroupsSteps().addGroup(
                new AdGroupAddItemMap()
                        .defaultAdGroupAddItem(campaignId)
        );

        adGroupIdWithFeed = api.userSteps.adGroupsSteps().addGroup(
                new AdGroupAddItemMap()
                        .defaultAdGroupAddItem(campaignId)
                        .withTextAdGroupFeedParams(feedId, feedCategoryIds)
        );
    }

    @Before
    @Step("Подготовка данных для теста")
    public void init() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
    }

    @Test
    public void fieldNamesWithTwoFields() {
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(adGroupId)
                        )
                        .withFieldNames(AdGroupFieldEnum.ID)
                        .withTextAdGroupFeedParamsFieldNames(TextAdGroupFeedParamsFieldEnum.FEED_ID,
                                TextAdGroupFeedParamsFieldEnum.FEED_CATEGORY_IDS)
        );

        MobileAppAdGroupGetMap expected = new MobileAppAdGroupGetMap()
                .withStoreUrl(MobileAppAdGroupAddMap.DEFAULT_STORE_URL)
                .withTargetDeviceTypes(MobileAppAdGroupAddMap.DEFAULT_TARGET_DEVICE_TYPE);
        assertThat("вернулась правильная группа", response.getAdGroups(), beanDifferV5(Collections.singletonList(
                new AdGroupGetItemMap().withId(adGroupId).withTextAdGroupFeedParams().getBean())));
    }

}
