package ru.yandex.autotests.direct.api.adgroups.negativekeywordsharedsets;

import java.util.List;

import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.negativekeywordsharedsets.AddResponse;
import com.yandex.direct.api.v5.negativekeywordsharedsets.GetResponse;
import com.yandex.direct.api.v5.negativekeywordsharedsets.NegativeKeywordSharedSetFieldEnum;
import com.yandex.direct.api.v5.negativekeywordsharedsets.NegativeKeywordSharedSetGetItem;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.negativekeywordsharedsets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.negativekeywordsharedsets.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.negativekeywordsharedsets.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.negativekeywordsharedsets.NegativeKeywordSharedSetAddItemMap;
import ru.yandex.autotests.directapi.model.api5.negativekeywordsharedsets.NegativeKeywordSharedSetUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.negativekeywordsharedsets.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.steps.banners.NegativeKeywordsSharedSetsSteps;
import ru.yandex.qatools.allure.annotations.Description;

import static java.util.Arrays.asList;
import static org.hamcrest.Matchers.contains;
import static org.junit.Assert.assertThat;

@Aqua.Test
@Description("Работа с библиотечными наборами минус фраз")
public class NegativeKeywordsSharedSetsTest {
    private static final String client = AdGroupsLogins.CLIENT;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(client);

    private NegativeKeywordsSharedSetsSteps negativeKeywordsSharedSetsSteps;

    @Before
    public void before() {
        negativeKeywordsSharedSetsSteps = api.userSteps.negativeKeywordsSharedSetsSteps();
    }

    @Test
    public void addNegativeKeywordsSharedSet() {
        AddRequestMap addRequestMap = new AddRequestMap()
                .withNegativeKeywordSharedSets(new NegativeKeywordSharedSetAddItemMap()
                        .withName("First pack")
                        .withNegativeKeywords(asList("продать авто", "продать автозапчасти")));
        AddResponse addResponse = negativeKeywordsSharedSetsSteps.shouldGetResultOnAdd(addRequestMap, null,
                ExpectedResult.success());
        Long setId = addResponse.getAddResults().get(0).getId();
        negativeKeywordsSharedSetsSteps.negativeKeywordsSharedSetsDelete(
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(setId)),
                client);
    }

    @Test
    public void getNegativeKeywordsSharedSet() {
        String setName = "First pack";
        List<String> negativeKeywords = asList("продать авто", "продать автозапчасти");
        Long setId = negativeKeywordsSharedSetsSteps.addNegativeKeywordsSharedSet(new AddRequestMap()
                .withNegativeKeywordSharedSets(new NegativeKeywordSharedSetAddItemMap()
                        .withName(setName)
                        .withNegativeKeywords(negativeKeywords)));

        GetResponse getResponse =
                negativeKeywordsSharedSetsSteps.negativeKeywordsSharedSetsGet(new GetRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap().withIds(setId))
                        .withFieldNames(NegativeKeywordSharedSetFieldEnum.ID, NegativeKeywordSharedSetFieldEnum.NAME,
                                NegativeKeywordSharedSetFieldEnum.NEGATIVE_KEYWORDS,
                                NegativeKeywordSharedSetFieldEnum.ASSOCIATED), null);

        NegativeKeywordSharedSetGetItem expected = new NegativeKeywordSharedSetGetItem();
        expected.setId(setId);
        expected.setName(setName);
        expected.setNegativeKeywords(negativeKeywords);
        expected.setAssociated(YesNoEnum.NO);
        assertThat("вернулся ожидаемый набор минус фраз", getResponse.getNegativeKeywordSharedSets(),
                contains(expected));
        negativeKeywordsSharedSetsSteps.negativeKeywordsSharedSetsDelete(
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(setId)),
                client);
    }

    @Test
    public void updateNegativeKeywordsSharedSet() {
        Long setId = negativeKeywordsSharedSetsSteps.addDefaultNegativeKeywordsSharedSet();
        UpdateRequestMap updateRequestMap = new UpdateRequestMap()
                .withNegativeKeywordSharedSets(new NegativeKeywordSharedSetUpdateItemMap()
                        .withId(setId)
                        .withName("Новый измененный набор")
                        .withNegativeKeywords(asList("другие минус фразы", "закупка велосипедов")));
        negativeKeywordsSharedSetsSteps.shouldGetResultOnUpdate(updateRequestMap, null, ExpectedResult.success());
        negativeKeywordsSharedSetsSteps.negativeKeywordsSharedSetsDelete(
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(setId)),
                client);
    }

    @Test
    public void deleteNegativeKeywordsSharedSet() {
        Long setId = negativeKeywordsSharedSetsSteps.addDefaultNegativeKeywordsSharedSet();

        negativeKeywordsSharedSetsSteps.shouldGetResultOnDelete(new DeleteRequestMap()
                .withSelectionCriteria(new IdsCriteriaMap().withIds(setId)), null, ExpectedResult.success());
    }
}
