package ru.yandex.autotests.direct.api.adgroups.ping;

import java.util.EnumSet;

import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Parameterized.Parameter;
import org.junit.runners.Parameterized.Parameters;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;

import static java.util.stream.Collectors.toList;
import static org.hamcrest.Matchers.is;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-70939")
@Tag(TagDictionary.TRUNK)
@Features(ApiFeatures.JAVA_UP)
@Description("Проверка сервисов, не переключенных на Java")
@RunWith(Parameterized.class)
public class PingJavaApiNegativeTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @Parameter
    public ServiceNames service;

    @Parameters(name = "{0}")
    public static Iterable<Object[]> perlServices() {
        return EnumSet.complementOf(PingJavaApiServices.javaServices).stream()  // все не Java
                .filter(s -> s != ServiceNames.REPORTS) // Reports возвращает другой код – 400
                .map(s -> new Object[]{s})
                .collect(toList());
    }

    @Test
    public void checkNonJavaServices() {
        assertThat(String.format("API сервис %s не переключен на Java", service),
                api.pingJavaApiSteps().isPerlApiUp(service),
                is(true));
    }

}
