package ru.yandex.autotests.direct.api.adgroups.ping;

import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Parameterized.Parameter;
import org.junit.runners.Parameterized.Parameters;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;

import static java.util.stream.Collectors.toList;
import static org.hamcrest.Matchers.is;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-70939")
@Tag(TagDictionary.TRUNK)
@Features(ApiFeatures.JAVA_UP)
@Description("Проверка сервисов, переключенных на Java")
@RunWith(Parameterized.class)
public class PingJavaApiTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(AdGroupsLogins.CLIENT);

    @Parameter
    public ServiceNames service;

    @Parameters(name = "{0}")
    public static Iterable<Object[]> javaServices() {
        return PingJavaApiServices.javaServices.stream()
                .map(s -> new Object[]{s})
                .collect(toList());
    }

    @Test
    public void checkJavaServices() {
        assertThat(String.format("API сервис %s переключен на Java", service),
                api.pingJavaApiSteps().isJavaApiUp(service),
                is(true));
    }

}
