package ru.yandex.autotests.direct.api.adgroups.update;

import java.util.Collection;

import com.yandex.direct.api.v5.adgroups.AddResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.common.RegionIDValues;
import ru.yandex.autotests.directapi.model.common.RemovedRegionIDValues;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by onotole on 9/29/16.
 * https://st.yandex-team.ru/DIRECT-56940
 */
@Aqua.Test
@Features(ApiFeatures.NOT_REGRESSION_YET)
@Description("проверяем, что нельзя обновлением adGroup задать удаленный регион")
@RunWith(Parameterized.class)
@Tag(TagDictionary.NEVER_RUN)
public class CheckRemoveRegionsTest {
    private static final String client = Logins.CLIENT_FOR_RUB;
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    @Parameterized.Parameter(0)
    public Long geoRegionId;
    @Rule
    public Trashman trasher = new Trashman(api);
    private Long adGroupId;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> testData() {
        return RemovedRegionIDValues.values;
    }

    @Before
    public void createDefaultAdGroup() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        AddResponse response = api.userSteps.adGroupsSteps().adGroupsAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId)
                )
        );
        assumeThat("AdGroup добавился успешно", response.getAddResults().size(), equalTo(1));
        adGroupId = response.getAddResults().get(0).getId();
    }

    @Test
    public void updateAdGroupWithRemovedRegion() {
        api.userSteps.adGroupsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAdGroups(
                        new AdGroupUpdateItemMap()
                                .withId(adGroupId)
                                .withRegionIds(geoRegionId)
                ),
                ExpectedResult.errors(new Notification(5120,
                        Api5ErrorDetailsJava.INVALID_OR_NONEXISTENT_REGION, geoRegionId)));
    }

    @Test
    public void updateAdGroupWithMinusRemovedRegion() {
        Long minusRegionId = -geoRegionId;
        api.userSteps.adGroupsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAdGroups(
                        new AdGroupUpdateItemMap()
                                .withId(adGroupId)
                                .withRegionIds(Long.valueOf(RegionIDValues.UKRAINIAN_REGION_ID), minusRegionId)
                ),
                ExpectedResult.errors(new Notification(5120,
                        Api5ErrorDetailsJava.INVALID_OR_NONEXISTENT_REGION, minusRegionId)));
    }
}
