package ru.yandex.autotests.direct.api.adgroups.update;

import com.yandex.direct.api.v5.adgroups.AdGroupGetItem;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupGetItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.beandiffer2.beanfield.BeanFieldPath;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by ginger on 28.09.16.
 * https://st.yandex-team.ru/TESTIRT-10266
 */
@Aqua.Test
@Features(AdGroupsFeatures.UPDATE)
@Description("Обновление текстовых групп и проверка их состояния в ответе метода Get")
@Issue("https://st.yandex-team.ru/DIRECT-58442")
public class UpdateAdGroupAndCheckGetResponseTest {
    private static final String CLIENT = AdGroupsLogins.CLIENT;
    private static Long adGroupId;
    private static AdGroupGetItem adGroupBeforeUpdate;
    private static AdGroupGetItem adGroupAfterUpdate;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void prepareData(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addGroup(new AdGroupAddItemMap()
                .defaultAdGroupAddItem(campaignId)
                .withTrackingParams(AdGroupAddItemMap.DEFAULT_TRACKING_PARAMS)
                .withNegativeKeywords(AdGroupAddItemMap.DEFAULT_NEGATIVE_KEYWORD)
        );

        adGroupBeforeUpdate = api.userSteps.adGroupsSteps().adGroupsGetById(adGroupId).get(0);

        api.userSteps.adGroupsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAdGroups(new AdGroupUpdateItemMap()
                        .withId(adGroupId)
                        .withName(AdGroupAddItemMap.DEFAULT_NAME + "Updated")),
                ExpectedResult.success()
        );

        adGroupAfterUpdate = api.userSteps.adGroupsSteps().adGroupsGetById(adGroupId).get(0);
    }

    @Test
    public void checkGetResponseAfterUpdateAdGroup(){
        assertThat("в группе не изменилось ничего лишнего",
                adGroupAfterUpdate, beanDiffer(adGroupBeforeUpdate)
                        .useCompareStrategy(DefaultCompareStrategies.allFieldsExcept(
                                BeanFieldPath.newPath(AdGroupGetItemMap.NAME)
                        )));
    }
}
