package ru.yandex.autotests.direct.api.adgroups.update;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.RandomUtils;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by ginger on 15.12.2015.
 * https://st.yandex-team.ru/TESTIRT-7951
 */
@Aqua.Test
@Features(AdGroupsFeatures.UPDATE)
@Issue("https://st.yandex-team.ru/DIRECT-48813")
@Description("Проверка доступа агентства к  группам субклиента при обновлении группы")
public class UpdateAdGroupsAgencyAccessTest {
    private static final String singleClient = AdGroupsLogins.CLIENT;

    private static final String agency = AdGroupsLogins.AGENCY_SHARD2;
    private static final String subclient1 = AdGroupsLogins.AGENCY_SHARD2_SUB_SH1;
    private static final String subclient2 = AdGroupsLogins.AGENCY_SHARD2_SUB_SH2;
    private static final String name = RandomUtils.getString(5);

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void reshardUsers() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(singleClient);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(agency);
        api.userSteps.clientFakeSteps().reshardUserWithLock(agency, ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(subclient1, ShardNumbers.DEFAULT_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(subclient2, ShardNumbers.EXTRA_SHARD);
    }

    @Test
    @Description("Обновим агентством группу субклиента, указав группу другого сублиента")
    public void anotherSubclientAdGroupTest() {
        Long campaignID = api.as(agency).userSteps.campaignSteps().addDefaultTextCampaign(subclient2);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID.intValue(), subclient2);
        api.userSteps.adGroupsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAdGroups(
                        new AdGroupUpdateItemMap()
                                .withId(adGroupId)
                                .withName(name)
                ),
                subclient1,
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.GROUP_NOT_FOUND))
        );
    }

    @Test
    @Description("Обновим агентством группу субклиента, указав его группу и группу другого сублиента")
    public void ownedAdGroupAndAnotherSubclientAdGroupTest() {
        Long campaignID1 = api.as(agency).userSteps.campaignSteps().addDefaultTextCampaign(subclient1);
        Long adGroupId1 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID1.intValue(), subclient1);
        Long campaignID2 = api.userSteps.campaignSteps().addDefaultTextCampaign(subclient2);
        Long adGroupId2 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID2.intValue(), subclient2);
        api.userSteps.adGroupsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAdGroups(
                        new AdGroupUpdateItemMap()
                                .withId(adGroupId1)
                                .withName(name),
                        new AdGroupUpdateItemMap()
                                .withId(adGroupId2)
                                .withName(name+"2")
                ),
                subclient1,
                ExpectedResult.success(),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.GROUP_NOT_FOUND))
        );
    }

    @Test
    @Description("Обновим агентством группу субклиента, указав группу самостоятельного клиента")
    public void nonOwnedAdGroupByAgencyTest() {
        Long campaignID = api.as(singleClient).userSteps.campaignSteps().addDefaultTextCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID.intValue(), singleClient);
        api.as(agency).userSteps.adGroupsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAdGroups(
                        new AdGroupUpdateItemMap()
                                .withId(adGroupId)
                                .withName(name)
                ),
                subclient1,
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.GROUP_NOT_FOUND)));
    }
}
