package ru.yandex.autotests.direct.api.adgroups.update;

import java.util.Arrays;

import com.google.common.primitives.Longs;
import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.GetResponse;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupGetItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.MobileAppAdGroupAddMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.common.RegionIDValues;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by proxeter on 14.01.16.
 *
 * https://st.yandex-team.ru/TESTIRT-7903
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-48365")
@Features(AdGroupsFeatures.UPDATE)
@Description("Проверка корректности сохранения данных при обновлении группы объявлений в обратном порядке")
public class UpdateAdGroupsInReverseOrderTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(AdGroupsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long adGroupId1;
    private static Long adGroupId2;

    private static Long campaignId;

    private static final String nameForAdGroup1 = RandomStringUtils.randomAlphabetic(8);
    private static final String nameForAdGroup2 = RandomStringUtils.randomAlphabetic(8);

    private static final Long[] regionsForAdGroup1 = new Long[] { Longs.tryParse(RegionIDValues.SNG_REGION_ID) };
    private static final Long[] regionsForAdGroup2 = new Long[] { Longs.tryParse(RegionIDValues.CRIMEA_REGION_ID) };

    @Before
    @Step("Подготовка данных для теста")
    public void createAdGroup() {
        campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);

        adGroupId1 = api.userSteps.adGroupsSteps().addGroup(
                new AdGroupAddItemMap()
                        .withMobileAppAdGroup(new MobileAppAdGroupAddMap().defaultGroup())
                        .withName(RandomStringUtils.randomAlphabetic(8))
                        .withRegionIds(regionsForAdGroup1)
                        .withCampaignId(campaignId)
        );

        adGroupId2 = api.userSteps.adGroupsSteps().addGroup(
                new AdGroupAddItemMap()
                        .withMobileAppAdGroup(new MobileAppAdGroupAddMap().defaultGroup())
                        .withName(RandomStringUtils.randomAlphabetic(8))
                        .withRegionIds(regionsForAdGroup2)
                        .withCampaignId(campaignId)
        );
    }

    @Test
    public void updateAdGroupsInReverseOrder() {
        api.userSteps.adGroupsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAdGroups(
                        new AdGroupUpdateItemMap().withId(adGroupId2).withName(nameForAdGroup2),
                        new AdGroupUpdateItemMap().withId(adGroupId1).withName(nameForAdGroup1)

                ),
                ExpectedResult.success(adGroupId2), ExpectedResult.success(adGroupId1)
        );

        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(new AdGroupsSelectionCriteriaMap().withIds(adGroupId1, adGroupId2))
                        .withFieldNames(AdGroupFieldEnum.ID, AdGroupFieldEnum.NAME, AdGroupFieldEnum.REGION_IDS)
        );

        assertThat("объявления обновились правильно",response.getAdGroups(), beanDiffer(Arrays.asList(
                new AdGroupGetItemMap()
                        .withId(adGroupId1)
                        .withName(nameForAdGroup1)
                        .withRegionIds(regionsForAdGroup1).getBean(),
                new AdGroupGetItemMap()
                        .withId(adGroupId2)
                        .withName(nameForAdGroup2)
                        .withRegionIds(regionsForAdGroup2).getBean()))
        );

    }

}
