package ru.yandex.autotests.direct.api.adgroups.update;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.MobileAppAdGroupUpdateMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 14.10.15.
 * https://st.yandex-team.ru/TESTIRT-7178
 */
@Aqua.Test
@Features(AdGroupsFeatures.UPDATE)
@Stories(AdGroupsStories.MOBILE)
@Description("Использование в запросе AdGroups.update разных типов групп")
@Issue("https://st.yandex-team.ru/DIRECT-44780")
public class UpdateDifferentTypesOfAdGroupsInOneRequestTest {

    private static final String client = AdGroupsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    static Integer campaignIdMobile;
    static Long campaignIdText;
    static Long mobileId;
    static Long textId;

    @BeforeClass
    public static void initTest() {
        campaignIdText = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        textId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignIdText);
        campaignIdMobile = api.userSteps.campaignSteps().addDefaultMobileAppCampaign().intValue();
        mobileId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignIdMobile);
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    public void tryUpdateTypeForTextAdGroup() {
        //DIRECT-47392
        api.userSteps.adGroupsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAdGroups(new AdGroupUpdateItemMap()
                                .withId(textId)
                                .withMobileAppAdGroup(new MobileAppAdGroupUpdateMap()
                                )),
                ExpectedResult.errors(
                        new Notification(4000, Api5ErrorDetails.ADGROUP_TYPE_NOT_MATCHES_WITH_TYPE_IN_REQUEST)));
    }

    @Test
    public void tryUpdateTypeForDifferentAdGroups() {
        api.userSteps.adGroupsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAdGroups(
                                new AdGroupUpdateItemMap()
                                        .withId(textId)
                                , new AdGroupUpdateItemMap()
                                        .withId(mobileId)
                                        .withMobileAppAdGroup(new MobileAppAdGroupUpdateMap())
                        ),
                ExpectedResult.success(),
                ExpectedResult.success()
        );
    }

    @Test
    public void tryUpdateTypeForDifferentAdGroupsNegative() {
        api.userSteps.adGroupsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAdGroups(
                                new AdGroupUpdateItemMap()
                                        .withId(textId)
                                        .withMobileAppAdGroup(new MobileAppAdGroupUpdateMap())
                                , new AdGroupUpdateItemMap()
                                        .withId(mobileId)
                                        .withMobileAppAdGroup(new MobileAppAdGroupUpdateMap())
                        ),
                ExpectedResult.errors(
                        new Notification(4000, Api5ErrorDetails.ADGROUP_TYPE_NOT_MATCHES_WITH_TYPE_IN_REQUEST)),
                ExpectedResult.success()
        );
    }
}
