package ru.yandex.autotests.direct.api.adgroups.update;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.GroupFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.common.RegionIDValues;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(AdGroupsFeatures.UPDATE)
@Tag(TagDictionary.TRUNK)
@Issue("https://st.yandex-team.ru/DIRECT-74294")
@Description("Проверка преобразования массива регионов, переданных в AdGroups.update")
public class UpdateGeoAndCheckUseRefineGeoIdTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(AdGroupsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    Long adGroupId;

    private String getGroupStatusBsSynced(Long adGroupID) {
        GroupFakeInfo groupFakeInfo = api.userSteps.groupFakeSteps().getGroupParams(adGroupID);
        return groupFakeInfo.getStatusBsSynced();
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createGroupAndBanner() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();

        adGroupId = api.userSteps.adGroupsSteps().addGroup(
                new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId)
                        .withRegionIds(Long.parseLong(RegionIDValues.ANY_REGION_ID)));

        Long adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        api.userSteps.campaignFakeSteps().makeCampaignModerated(campaignId.intValue());
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(adGroupId, Status.YES);
        api.userSteps.groupFakeSteps().setStatusModerate(adGroupId, Status.YES);
        api.userSteps.bannersFakeSteps().makeBannersModerated(adId);
        api.userSteps.bannersFakeSteps().setStatusBsSynced(adId, Status.YES);

        assumeThat("группе установился нужный статус синхронизации с БК",
                getGroupStatusBsSynced(adGroupId), equalTo(Status.YES));

        api.userSteps.adGroupsSteps().adGroupsUpdate(
                new UpdateRequestMap().withAdGroups(
                        new AdGroupUpdateItemMap().withId(adGroupId)
                                .withRegionIds(-Long.parseLong(RegionIDValues.MOSCOW_ID),
                                        Long.parseLong(RegionIDValues.RUSSIA_REGION_ID))));
    }

    @Test
    public void checkStatusBsSynced() {
        assertThat("группа имеет правильный статус синхронизации с БК",
                getGroupStatusBsSynced(adGroupId),
                equalTo(Status.NO));
    }

    @Test
    public void checkGeoInDb() {
        String geoInDb = api.userSteps.getDirectJooqDbSteps().useShardForLogin(AdGroupsLogins.CLIENT).adGroupsSteps()
                .getPhrases(adGroupId).getGeo();
        assertThat("в базу записались правильные регионы",
                geoInDb,
                equalTo(String.join(",", RegionIDValues.RUSSIA_REGION_ID, "-" + RegionIDValues.MOSCOW_ID)));
    }
}
