package ru.yandex.autotests.direct.api.adgroups.update;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.utils.model.RegionIDValues;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 23.04.15.
 * https://st.yandex-team.ru/TESTIRT-5321
 */
@Aqua.Test
@Features(AdGroupsFeatures.UPDATE)
@Tag(TagDictionary.TRUNK)
@Description("Проверка запрета смены региона при наличии в группе баннера со специфическим текстом")
@RunWith(Parameterized.class)
public class UpdateGeoMatchingTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(AdGroupsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long adGroupId;
    private Long adId;

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public Long regionId;

    @Parameterized.Parameter(2)
    public String text;

    @Parameterized.Parameter(3)
    public Api5ErrorDetails expectedErrorDetail;

    @Parameterized.Parameter(4)
    public Api5ErrorDetailsJava expectedJavaErrorDetail;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"Смена региона у группы с баннером с украинским текстом",
                        RegionIDValues.UKRAINE.getId().longValue(), "Горілка",
                        Api5ErrorDetails.ENABLE_GEO_ONLY_FOR_UKRAINE,
                        Api5ErrorDetailsJava.ENABLE_GEO_ONLY_FOR_UKRAINE},
                {"Смена региона у группы с баннером с турецким текстом",
                        RegionIDValues.TURKEY.getId().longValue(), "türkiye",
                        Api5ErrorDetails.ENABLE_GEO_ONLY_FOR_TURKEY,
                        Api5ErrorDetailsJava.ENABLE_GEO_ONLY_FOR_TURKEY},
                {"Смена региона у группы с баннером с казахским текстом",
                        RegionIDValues.KAZAKHSTAN.getId().longValue(), "арақ",
                        Api5ErrorDetails.ENABLE_GEO_ONLY_FOR_KAZAKHSTAN,
                        Api5ErrorDetailsJava.ENABLE_GEO_ONLY_FOR_KAZAKHSTAN},
        });
    }

    @Before
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdGroupsLogins.CLIENT);
        adGroupId = api.userSteps.adGroupsSteps().addGroup(
                new AdGroupAddItemMap()
                        .withCampaignId(campaignId)
                        .withName(AdGroupAddItemMap.DEFAULT_NAME)
                        .withRegionIds(regionId));
        adId = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withTextAd(new TextAdAddMap()
                        .withText(text)
                        .withTitle(TextAdAddMap.DEFAULT_TITLE)
                        .withHref(TextAdAddMap.DEFAULT_HREF)
                        .withMobile(YesNoEnum.NO))
                .withAdGroupId(adGroupId));
    }

    @Test
    public void updateAdGroup() {
        api.userSteps.adGroupsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAdGroups(new AdGroupUpdateItemMap()
                        .withId(adGroupId)
                        .withRegionIds(RegionIDValues.RUSSIA.getId().longValue())),
                ExpectedResult.errors(new Notification(6100, expectedJavaErrorDetail, adId)));
    }
}
