package ru.yandex.autotests.direct.api.adgroups.update;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampOptionsRecord;
import ru.yandex.autotests.direct.utils.model.RegionIDValues;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.enums.CampaignLanguage;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 20.05.16.
 * https://st.yandex-team.ru/TESTIRT-9318
 */
@Aqua.Test
@Features(AdGroupsFeatures.UPDATE)
@Description("Проверка смены региона при наличии настройки кампании на определенный язык")
@Issue("https://st.yandex-team.ru/DIRECT-54330")
@RunWith(Parameterized.class)
public class UpdateGeoMatchingWithCampLangTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(AdGroupsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long adGroupId;

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public Long regionId;

    @Parameterized.Parameter(2)
    public CampaignLanguage campLang;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"Смена региона у группы в кампании с английским языком",
                        RegionIDValues.ENGLAND.getId().longValue(), CampaignLanguage.ENGLISH},
                {"Смена региона у группы в кампании с немецким языком",
                        RegionIDValues.GERMANY.getId().longValue(), CampaignLanguage.GERMAN},
                {"Смена региона у группы в кампании с русским языком",
                        RegionIDValues.RUSSIA.getId().longValue(), CampaignLanguage.RUSSIAN},
        });
    }

    @Before
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
        int shard = api.userSteps.clientFakeSteps().getUserShard(AdGroupsLogins.CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addGroup(
                new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId)
                        .withRegionIds(regionId));
        Long adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        CampOptionsRecord campOptions = api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                        .getCampOptionsById(campaignId);
        campOptions.setContentLang(campLang.value());
        api.userSteps.getDirectJooqDbSteps().campaignsSteps().updateCampOptions(campOptions);
    }

    @Test
    public void updateAdGroup() {
        api.userSteps.adGroupsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAdGroups(new AdGroupUpdateItemMap()
                        .withId(adGroupId)
                        .withRegionIds(RegionIDValues.UKRAINE.getId().longValue())),
                ExpectedResult.success());
    }
}
