package ru.yandex.autotests.direct.api.adgroups.update;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.GroupFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Author pavryabov
 * Date 15.09.14
 * https://jira.yandex-team.ru/browse/TESTIRT-2022
 */
@Aqua.Test
@Features(AdGroupsFeatures.UPDATE)
@Tag(TagDictionary.TRUNK)
public class UpdateGroupAndCheckStatusBsSynced {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(AdGroupsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    Long id;

    @Before
    @Step("Подготовка данных для теста")
    public void createGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdGroupsLogins.CLIENT);
        id = api.userSteps.adGroupsSteps().addGroup(new AdGroupAddItemMap()
                .defaultAdGroupAddItem(campaignId)
                .withTrackingParams(AdGroupAddItemMap.DEFAULT_TRACKING_PARAMS)
                .withNegativeKeywords(AdGroupAddItemMap.DEFAULT_NEGATIVE_KEYWORD)
        );
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(id, Status.YES);
        api.userSteps.groupFakeSteps().setStatusModerate(id, Status.YES);
        GroupFakeInfo groupBeforeUpdate = api.userSteps.groupFakeSteps().getGroupParams(id);
        assumeThat("группе установился нужный статус синхронизации с БК",
                groupBeforeUpdate.getStatusBsSynced(), equalTo(Status.YES));
    }

    // updateRegionIds перенесён в UpdateGeoAndCheckStatusBsSyncedTest

    @Test
    public void updateName() {
        //DIRECT-35080
        api.userSteps.adGroupsSteps().adGroupsUpdate(
                new UpdateRequestMap().withAdGroups(
                        new AdGroupUpdateItemMap().withId(id).withName(AdGroupAddItemMap.DEFAULT_NAME + "new")));
        GroupFakeInfo groupFakeInfo = api.userSteps.groupFakeSteps().getGroupParams(id);
        assertThat("статусы синхронизации с БК не обновился", groupFakeInfo.getStatusBsSynced(), equalTo(Status.YES));
    }

    @Test
    public void updateNegativeKeywords() {
        //DIRECT-35080
        api.userSteps.adGroupsSteps().adGroupsUpdate(
                new UpdateRequestMap().withAdGroups(
                        new AdGroupUpdateItemMap()
                                .withId(id)
                                .withNegativeKeywords(AdGroupAddItemMap.DEFAULT_NEGATIVE_KEYWORD + "new")));
        GroupFakeInfo groupFakeInfo = api.userSteps.groupFakeSteps().getGroupParams(id);
        assertThat("статусы синхронизации с БК обновился", groupFakeInfo.getStatusBsSynced(), equalTo(Status.NO));
    }

    @Test
    @Issue("https://st.yandex-team.ru/DIRECT-51468#1457351722000")
    public void updateTrackingParams() {
        api.userSteps.adGroupsSteps().adGroupsUpdate(
                new UpdateRequestMap().withAdGroups(new AdGroupUpdateItemMap()
                        .withId(id)
                        .withTrackingParams(AdGroupAddItemMap.DEFAULT_TRACKING_PARAMS+"api")
                ));
        GroupFakeInfo groupFakeInfo = api.userSteps.groupFakeSteps().getGroupParams(id);
        assertThat("статус синхронизации с БК обновился", groupFakeInfo.getStatusBsSynced(), equalTo(Status.NO));
    }
}
