package ru.yandex.autotests.direct.api.adgroups.update;

import java.util.HashMap;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupBaseMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ArrayOfStringMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by pavryabov on 10.12.14.
 * https://st.yandex-team.ru/TESTIRT-3706
 */
@Aqua.Test
@Features(AdGroupsFeatures.UPDATE)
@Stories(ApiStories.JSON5)
public class UpdateJSONTest {
    private static final String CLIENT = AdGroupsLogins.CLIENT;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().protocol(ProtocolType.JSON).as(CLIENT);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();
    @Rule
    public Trashman trashman = new Trashman(api);

    static Long campaignId;
    static Long id;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdGroupsLogins.CLIENT);
        id = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
    }

    @Test
    public void updateWithoutId() {
        JSONObject request = new JSONObject();
        JSONObject adGroups = new JSONObject();
        adGroups.put(capitalize(AdGroupUpdateItemMap.NAME), AdGroupAddItemMap.DEFAULT_NAME);
        adGroups.put(capitalize(AdGroupBaseMap.REGION_IDS), new Long[]{AdGroupAddItemMap.DEFAULT_REGION_ID});
        request.put(capitalize(UpdateRequestMap.AD_GROUPS), new Object[]{adGroups});

        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsUpdate(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.IN_ELEMENT_OF_ARRAY_MISSING_REQUIRED_FIELD,
                        capitalize(UpdateRequestMap.AD_GROUPS),
                        capitalize(AdGroupUpdateItemMap.ID)));
    }

    @Test
    public void updateWithStringInId() {
        JSONObject request = new JSONObject();
        JSONObject adGroups = new JSONObject();
        adGroups.put(capitalize(AdGroupUpdateItemMap.NAME), AdGroupAddItemMap.DEFAULT_NAME);
        adGroups.put(capitalize(AdGroupUpdateItemMap.ID), "string");
        adGroups.put(capitalize(AdGroupBaseMap.REGION_IDS), new Long[]{AdGroupAddItemMap.DEFAULT_REGION_ID});
        request.put(capitalize(UpdateRequestMap.AD_GROUPS), new Object[]{adGroups});

        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsUpdate(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                        path(UpdateRequestMap.AD_GROUPS, AdGroupUpdateItemMap.ID)));
    }

    @Test
    public void updateWithStringInRegionIds() {
        JSONObject request = new JSONObject();
        JSONObject adGroups = new JSONObject();
        adGroups.put(capitalize(AdGroupUpdateItemMap.NAME), AdGroupAddItemMap.DEFAULT_NAME);
        adGroups.put(capitalize(AdGroupUpdateItemMap.ID), id);
        adGroups.put(capitalize(AdGroupBaseMap.REGION_IDS), new String[]{"string"});
        request.put(capitalize(UpdateRequestMap.AD_GROUPS), new Object[]{adGroups});

        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsUpdate(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
                        path(UpdateRequestMap.AD_GROUPS, AdGroupUpdateItemMap.REGION_IDS)));
    }

    @Test
    public void updateWithNotArrayInRegionIds() {
        //DIRECT-37558
        JSONObject request = new JSONObject();
        JSONObject adGroups = new JSONObject();
        adGroups.put(capitalize(AdGroupUpdateItemMap.NAME), AdGroupAddItemMap.DEFAULT_NAME);
        adGroups.put(capitalize(AdGroupUpdateItemMap.ID), id);
        adGroups.put(capitalize(AdGroupBaseMap.REGION_IDS), AdGroupAddItemMap.DEFAULT_REGION_ID);
        request.put(capitalize(UpdateRequestMap.AD_GROUPS), new Object[]{adGroups});

        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsUpdate(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                        path(UpdateRequestMap.AD_GROUPS, AdGroupUpdateItemMap.REGION_IDS)));
    }

    @Test
    public void updateWithInvalidField() {
        //DIRECT-37561
        JSONObject request = new JSONObject();
        JSONObject adGroups = new JSONObject();
        adGroups.put(capitalize(AdGroupUpdateItemMap.NAME), AdGroupAddItemMap.DEFAULT_NAME);
        adGroups.put(capitalize(AdGroupUpdateItemMap.ID), id);
        adGroups.put(AdGroupUpdateItemMap.ID, id);
        adGroups.put(capitalize(AdGroupBaseMap.REGION_IDS), new Long[]{AdGroupAddItemMap.DEFAULT_REGION_ID});
        request.put(capitalize(UpdateRequestMap.AD_GROUPS), new Object[]{adGroups});

        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsUpdate(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAIN_UNKNOWN_FIELD,
                        capitalize(UpdateRequestMap.AD_GROUPS), AdGroupUpdateItemMap.ID));
    }

    @Test
    public void updateWithNotArrayInNegativeKeywordsItems() {
        //DIRECT-37558
        JSONObject request = new JSONObject();
        JSONObject adGroups = new JSONObject();
        JSONObject negativeKeywords = new JSONObject();
        negativeKeywords.put(capitalize(ArrayOfStringMap.ITEMS), AdGroupAddItemMap.DEFAULT_NEGATIVE_KEYWORD);
        adGroups.put(capitalize(AdGroupUpdateItemMap.NAME), AdGroupAddItemMap.DEFAULT_NAME);
        adGroups.put(capitalize(AdGroupUpdateItemMap.ID), id);
        adGroups.put(capitalize(AdGroupBaseMap.REGION_IDS), new Long[]{AdGroupAddItemMap.DEFAULT_REGION_ID});
        adGroups.put(capitalize(AdGroupBaseMap.NEGATIVE_KEYWORDS), negativeKeywords);
        request.put(capitalize(UpdateRequestMap.AD_GROUPS), new Object[]{adGroups});

        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsUpdate(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                        path(
                                UpdateRequestMap.AD_GROUPS,
                                AdGroupUpdateItemMap.NEGATIVE_KEYWORDS,
                                ArrayOfStringMap.ITEMS)));
    }

    @Test
    public void updateWithNullInNegativeKeywordsItems() {
        //DIRECT-37558
        JSONObject request = new JSONObject();
        JSONObject adGroups = new JSONObject();
        JSONObject negativeKeywords = new JSONObject();
        negativeKeywords.put(capitalize(ArrayOfStringMap.ITEMS), "null");
        adGroups.put(capitalize(AdGroupUpdateItemMap.NAME), AdGroupAddItemMap.DEFAULT_NAME);
        adGroups.put(capitalize(AdGroupUpdateItemMap.ID), id);
        adGroups.put(capitalize(AdGroupBaseMap.REGION_IDS), new Long[]{AdGroupAddItemMap.DEFAULT_REGION_ID});
        adGroups.put(capitalize(AdGroupBaseMap.NEGATIVE_KEYWORDS), negativeKeywords);
        request.put(capitalize(UpdateRequestMap.AD_GROUPS), new Object[]{adGroups});

        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsUpdate(
                request,
                new Api5Error(8000, Api5ErrorDetails.CANNOT_HAVE_NULL_VALUE,
                        path(ArrayOfStringMap.ITEMS)));
    }

    @Test
    public void updateWithNoItemsInNegativeKeywords() {
        JSONObject request = new JSONObject();
        JSONObject adGroups = new JSONObject();
        adGroups.put(capitalize(AdGroupUpdateItemMap.NAME), AdGroupAddItemMap.DEFAULT_NAME);
        adGroups.put(capitalize(AdGroupUpdateItemMap.ID), id);
        adGroups.put(capitalize(AdGroupBaseMap.REGION_IDS), new Long[]{AdGroupAddItemMap.DEFAULT_REGION_ID});
        adGroups.put(capitalize(AdGroupBaseMap.NEGATIVE_KEYWORDS),
                new String[]{AdGroupAddItemMap.DEFAULT_NEGATIVE_KEYWORD});
        request.put(capitalize(UpdateRequestMap.AD_GROUPS), new Object[]{adGroups});

        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsUpdate(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        path(UpdateRequestMap.AD_GROUPS, AdGroupUpdateItemMap.NEGATIVE_KEYWORDS)));
    }

    @Test
    public void updateWithNotArrayInAdGroups() {
        //DIRECT-37558
        JSONObject request = new JSONObject();
        JSONObject adGroups = new JSONObject();
        adGroups.put(capitalize(AdGroupUpdateItemMap.NAME), AdGroupAddItemMap.DEFAULT_NAME);
        adGroups.put(capitalize(AdGroupUpdateItemMap.ID), id);
        adGroups.put(capitalize(AdGroupBaseMap.REGION_IDS), new Long[]{AdGroupAddItemMap.DEFAULT_REGION_ID});
        request.put(capitalize(UpdateRequestMap.AD_GROUPS), adGroups);

        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsUpdate(
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_ARRAY, capitalize(UpdateRequestMap.AD_GROUPS))
        );
    }

    private static class JSONObject extends HashMap<String, Object> {
    }
}
