package ru.yandex.autotests.direct.api.adgroups.update;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusmoderate;
import ru.yandex.autotests.direct.utils.matchers.BeanEquals;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.GroupFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.banners.BannerInfoMap;
import ru.yandex.autotests.directapi.model.common.RegionIDValues;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Author pavryabov
 * Date 15.09.14
 * https://jira.yandex-team.ru/browse/TESTIRT-2022
 */
@Aqua.Test
@Features(AdGroupsFeatures.UPDATE)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class UpdateRegionsAndCheckStatusModerates {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(AdGroupsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    Long id;
    GroupFakeInfo groupBeforeUpdate;

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public Long[] regionsBeforeUpdate;

    @Parameterized.Parameter(2)
    public Long[] regionsAfterUpdate;

    @Parameterized.Parameter(3)
    public String expectedStatusModerate;

    @Parameterized.Parameter(4)
    public String expectedStatusPostModerate;

    @Parameterized.Parameters(name = "{0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {"Moscow -> Spb", new Long[]{Long.valueOf(RegionIDValues.MOSCOW_ID)},
                        new Long[]{Long.valueOf(RegionIDValues.SPB_ID)},
                        Status.YES, Status.YES},
                {"Moscow -> Moscow, Kazakhstan", new Long[]{Long.valueOf(RegionIDValues.MOSCOW_ID)},
                        new Long[]{Long.valueOf(RegionIDValues.MOSCOW_ID), Long.valueOf(RegionIDValues.KAZAKH_REGION_ID)},
                        Status.YES, Status.YES},
                {"Moscow -> Kazakhstan", new Long[]{Long.valueOf(RegionIDValues.MOSCOW_ID)},
                        new Long[]{Long.valueOf(RegionIDValues.KAZAKH_REGION_ID)},
                        Status.READY, Status.NO},
                {"Moscow -> Astana", new Long[]{Long.valueOf(RegionIDValues.MOSCOW_ID)},
                        new Long[]{Long.valueOf(RegionIDValues.ASTANA_REGION_ID)},
                        Status.READY, Status.NO},
                {"Moscow, Kazakhstan -> Kazakhstan",
                        new Long[]{Long.valueOf(RegionIDValues.MOSCOW_ID), Long.valueOf(RegionIDValues.KAZAKH_REGION_ID)},
                        new Long[]{Long.valueOf(RegionIDValues.KAZAKH_REGION_ID)},
                        Status.READY, Status.NO},
                {"Kazakhstan -> Moscow, Kazakhstan", new Long[]{Long.valueOf(RegionIDValues.KAZAKH_REGION_ID)},
                        new Long[]{Long.valueOf(RegionIDValues.MOSCOW_ID), Long.valueOf(RegionIDValues.KAZAKH_REGION_ID)},
                        Status.YES, Status.YES},
                {"Kazakhstan -> Astana", new Long[]{Long.valueOf(RegionIDValues.KAZAKH_REGION_ID)},
                        new Long[]{Long.valueOf(RegionIDValues.ASTANA_REGION_ID)},
                        Status.YES, Status.YES},
                {"Kazakhstan -> Astana", new Long[]{Long.valueOf(RegionIDValues.KAZAKH_REGION_ID)},
                        new Long[]{Long.valueOf(RegionIDValues.ASTANA_REGION_ID)},
                        Status.YES, Status.YES},
                {"Astana -> Kazakhstan", new Long[]{Long.valueOf(RegionIDValues.ASTANA_REGION_ID)},
                        new Long[]{Long.valueOf(RegionIDValues.KAZAKH_REGION_ID)},
                        Status.YES, Status.YES},
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdGroupsLogins.CLIENT);
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(AdGroupsLogins.CLIENT)
                .campaignsSteps().setCampaignsStatusModerate(campaignId, CampaignsStatusmoderate.Yes);
        id = api.userSteps.adGroupsSteps().addGroup(new AdGroupAddItemMap()
                        .defaultAdGroupAddItem(campaignId)
                        .withRegionIds(regionsBeforeUpdate)
                        .withNegativeKeywords(AdGroupAddItemMap.DEFAULT_NEGATIVE_KEYWORD)
        );
        api.userSteps.keywordsSteps().addDefaultKeyword(id);
        api.userSteps.groupFakeSteps().setStatusModerate(id, Status.YES);
        api.userSteps.groupFakeSteps().setStatusPostModerate(id, Status.YES);
        groupBeforeUpdate = api.userSteps.groupFakeSteps().getGroupParams(id);
        assumeThat("группе установился нужный статус модерации",
                groupBeforeUpdate.getStatusModerate(), equalTo(Status.YES));
        assumeThat("группе установился нужный статус пост-модерации",
                groupBeforeUpdate.getStatusPostModerate(), equalTo(Status.YES));
    }

    @Test
    public void updateRegionIds() {
        //DIRECT-35071
        //DIRECT-36002
        api.userSteps.adGroupsSteps().adGroupsUpdate(
                new UpdateRequestMap().withAdGroups(
                        new AdGroupUpdateItemMap().withId(id).withRegionIds(regionsAfterUpdate)));
        GroupFakeInfo groupFakeInfo = api.userSteps.groupFakeSteps().getGroupParams(id);
        groupBeforeUpdate.setStatusModerate(expectedStatusModerate);
        groupBeforeUpdate.setStatusPostModerate(expectedStatusPostModerate);
        assertThat("статусы модерации верны",
                groupFakeInfo,
                BeanEquals.beanEquals(groupBeforeUpdate).ignoreFields("lastChange", BannerInfoMap.GEO));
    }
}
