package ru.yandex.autotests.direct.api.adgroups.update;

import java.util.Collections;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.GetResponse;
import com.yandex.direct.api.v5.adgroups.ObjectFactory;
import com.yandex.direct.api.v5.general.ArrayOfString;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.utils.matchers.BeanCompareStrategy;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupGetItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ArrayOfStringMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.contains;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Author pavryabov
 * Date 01.09.14
 * https://jira.yandex-team.ru/browse/TESTIRT-2022
 */
@Aqua.Test
@Features(AdGroupsFeatures.UPDATE)
@Tag(TagDictionary.TRUNK)
public class UpdateSetOfFieldsTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(AdGroupsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long campaignId;
    Long id;
    BeanCompareStrategy strategy;
    GetRequestMap getRequestMap;

    @BeforeClass
    public static void initTest() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdGroupsLogins.CLIENT);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
        id = api.userSteps.adGroupsSteps().addGroup(new AdGroupAddItemMap()
                .defaultAdGroupAddItem(campaignId)
                .withNegativeKeywords(AdGroupAddItemMap.DEFAULT_NEGATIVE_KEYWORD)
        );
        getRequestMap = new GetRequestMap()
                .withSelectionCriteria(
                        new AdGroupsSelectionCriteriaMap()
                                .withIds(id)
                )
                .withFieldNames(
                        AdGroupFieldEnum.ID,
                        AdGroupFieldEnum.CAMPAIGN_ID,
                        AdGroupFieldEnum.NAME,
                        AdGroupFieldEnum.REGION_IDS,
                        AdGroupFieldEnum.NEGATIVE_KEYWORDS
                );
        JAXBElement expectedNegativeKeywords = new ObjectFactory().createAdGroupBaseNegativeKeywords(
                (ArrayOfString) new ArrayOfStringMap()
                        .withItems(AdGroupAddItemMap.DEFAULT_NEGATIVE_KEYWORD).getBean());
        strategy = new BeanCompareStrategy()
                .putFieldMatcher(AdGroupGetItemMap.ID, equalTo(id))
                .putFieldMatcher(AdGroupGetItemMap.CAMPAIGN_ID, equalTo(campaignId))
                .putFieldMatcher(AdGroupGetItemMap.NAME, beanDifferV5(AdGroupAddItemMap.DEFAULT_NAME))
                .putFieldMatcher(AdGroupGetItemMap.REGION_IDS, equalTo(
                        Collections.singletonList(AdGroupAddItemMap.DEFAULT_REGION_ID)))
                .putFieldMatcher(AdGroupGetItemMap.NEGATIVE_KEYWORDS, beanDifferV5(expectedNegativeKeywords));
    }

    @Test
    public void updateWithOnlyId() {
        //DIRECT-34193
        api.userSteps.adGroupsSteps().adGroupsUpdate(
                new UpdateRequestMap().withAdGroups(new AdGroupUpdateItemMap()
                        .withId(id))
        );
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(getRequestMap);
        assertThat("вернулась правильная группа", response.getAdGroups(),
                contains(beanEquals(new AdGroupGetItemMap().getBean()).accordingStrategy(strategy)));
    }

    @Test
    public void updateOnlyName() {
        //DIRECT-34193
        api.userSteps.adGroupsSteps().adGroupsUpdate(
                new UpdateRequestMap().withAdGroups(new AdGroupUpdateItemMap()
                        .withId(id)
                        .withName(AdGroupAddItemMap.DEFAULT_NAME + "new"))
        );
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(getRequestMap);
        strategy.putFieldMatcher(AdGroupGetItemMap.NAME, beanDifferV5(AdGroupAddItemMap.DEFAULT_NAME + "new"));
        assertThat("вернулась правильная группа", response.getAdGroups(),
                contains(beanEquals(new AdGroupGetItemMap().getBean()).accordingStrategy(strategy)));
    }

    @Test
    public void updateOnlyRegionIds() {
        //DIRECT-34193
        api.userSteps.adGroupsSteps().adGroupsUpdate(
                new UpdateRequestMap().withAdGroups(new AdGroupUpdateItemMap()
                        .withId(id)
                        .withRegionIds(AdGroupAddItemMap.DEFAULT_REGION_ID + 1))
        );
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(getRequestMap);
        strategy.putFieldMatcher(
                AdGroupGetItemMap.REGION_IDS, equalTo(
                        Collections.singletonList(AdGroupAddItemMap.DEFAULT_REGION_ID + 1)));
        assertThat("вернулась правильная группа", response.getAdGroups(),
                contains(beanEquals(new AdGroupGetItemMap().getBean()).accordingStrategy(strategy)));
    }

    @Test
    public void updateOnlyNegativeKeywords() {
        //DIRECT-34717
        api.userSteps.adGroupsSteps().adGroupsUpdate(
                new UpdateRequestMap().withAdGroups(new AdGroupUpdateItemMap()
                        .withId(id)
                        .withNegativeKeywords(AdGroupAddItemMap.DEFAULT_NEGATIVE_KEYWORD + "new"))
        );
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(getRequestMap);
        JAXBElement expectedNegativeKeywords = new ObjectFactory().createAdGroupBaseNegativeKeywords(
                (ArrayOfString) new ArrayOfStringMap()
                        .withItems(AdGroupAddItemMap.DEFAULT_NEGATIVE_KEYWORD + "new").getBean());
        strategy.putFieldMatcher(AdGroupGetItemMap.NEGATIVE_KEYWORDS, beanDifferV5(expectedNegativeKeywords));
        assertThat("вернулась правильная группа", response.getAdGroups(),
                contains(beanEquals(new AdGroupGetItemMap().getBean()).accordingStrategy(strategy)));
    }

    @Test
    public void updateAllFields() {
        //DIRECT-34717
        api.userSteps.adGroupsSteps().adGroupsUpdate(
                new UpdateRequestMap().withAdGroups(new AdGroupUpdateItemMap()
                        .withId(id)
                        .withName(AdGroupAddItemMap.DEFAULT_NAME + "new")
                        .withRegionIds(AdGroupAddItemMap.DEFAULT_REGION_ID + 1)
                        .withNegativeKeywords(AdGroupAddItemMap.DEFAULT_NEGATIVE_KEYWORD + "new"))
        );
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(getRequestMap);
        JAXBElement expectedNegativeKeywords = new ObjectFactory().createAdGroupBaseNegativeKeywords(
                (ArrayOfString) new ArrayOfStringMap()
                        .withItems(AdGroupAddItemMap.DEFAULT_NEGATIVE_KEYWORD + "new").getBean());
        strategy.putFieldMatcher(AdGroupGetItemMap.NAME, beanDifferV5(AdGroupAddItemMap.DEFAULT_NAME + "new"));
        strategy.putFieldMatcher(
                AdGroupGetItemMap.REGION_IDS, equalTo(
                        Collections.singletonList(AdGroupAddItemMap.DEFAULT_REGION_ID + 1)));
        strategy.putFieldMatcher(AdGroupGetItemMap.NEGATIVE_KEYWORDS, beanDifferV5(expectedNegativeKeywords));
        assertThat("вернулась правильная группа", response.getAdGroups(),
                contains(beanEquals(new AdGroupGetItemMap().getBean()).accordingStrategy(strategy)));
    }

}
