package ru.yandex.autotests.direct.api.adgroups.update.cpmbanneradgroup;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampOptionsRecord;
import ru.yandex.autotests.direct.utils.model.RegionIDValues;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.enums.CampaignLanguage;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(AdGroupsFeatures.UPDATE)
@Description("Проверка запрета смены региона при наличии настройки кампании на определенный язык")
@Issue("https://st.yandex-team.ru/DIRECT-83722")
@RunWith(Parameterized.class)
public class CpmBannerAdGroupUpdateGeoMatchingWithCampLangTest {

    private static final String CLIENT = AdGroupsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long adGroupId;
    private Long adId;

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public Long regionId;

    @Parameterized.Parameter(2)
    public CampaignLanguage campLang;

    @Parameterized.Parameter(3)
    public Api5ErrorDetailsJava errorDetailJava;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"Смена региона у группы в кампании с украинским языком",
                        RegionIDValues.UKRAINE.getId().longValue(), CampaignLanguage.UKRAINIAN,
                        Api5ErrorDetailsJava.ENABLE_GEO_ONLY_FOR_UKRAINE},
                {"Смена региона у группы в кампании с турецким языком",
                        RegionIDValues.TURKEY.getId().longValue(), CampaignLanguage.TURKISH,
                        Api5ErrorDetailsJava.ENABLE_GEO_ONLY_FOR_TURKEY},
                {"Смена региона у группы в кампании с казахским языком",
                        RegionIDValues.KAZAKHSTAN.getId().longValue(), CampaignLanguage.KAZAKH,
                        Api5ErrorDetailsJava.ENABLE_GEO_ONLY_FOR_KAZAKHSTAN},
        });
    }

    @Before
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        int shard = api.userSteps.clientFakeSteps().getUserShard(CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().setType(campaignId, CampaignsType.CPM_BANNER);
        adGroupId = api.userSteps.adGroupsSteps().addGroup(
                new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId)
                        .withRegionIds(regionId)
                        .withCpmBannerUserProfileAdGroup());
        Long creativeId = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT).perfCreativesSteps()
                .saveDefaultCanvasCreativesForClient(Long.parseLong(User.get(CLIENT).getClientID()));
        adId = api.userSteps.adsSteps().addDefaultCpmBannerAdBuilderAd(adGroupId, creativeId);
        CampOptionsRecord campOptions = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .campaignsSteps().getCampOptionsById(campaignId);
        campOptions.setContentLang(campLang.value());
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .campaignsSteps().updateCampOptions(campOptions);
    }

    @Test
    public void updateAdGroup() {
        api.userSteps.adGroupsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAdGroups(new AdGroupUpdateItemMap()
                        .withId(adGroupId)
                        .withRegionIds(RegionIDValues.RUSSIA.getId().longValue())),
                ExpectedResult.errors(new Notification(6100, errorDetailJava, adId)));
    }
}
