package ru.yandex.autotests.direct.api.adgroups.update.cpmbanneradgroup;

import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.GroupFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(AdGroupsFeatures.UPDATE)
public class CpmBannerAdGroupUpdateLastChangeTest {

    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss");
    private static final DateTime LAST_CHANGE = DateTime.now().minusDays(5);

    private static final String CLIENT = AdGroupsLogins.CLIENT;
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    @Rule
    public Trashman trashman = new Trashman(api);
    private static Long pid;

    @BeforeClass
    public static void beforeClass() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().setType(campaignId, CampaignsType.CPM_BANNER);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        pid = api.userSteps.adGroupsSteps().addDefaultCpmBannerUserProfileAdGroup(campaignId);
    }

    @Before
    public void before() {
        api.userSteps.groupFakeSteps().setLastChange(pid, LAST_CHANGE.toString());

    }

    @Test
    public void testLastChange() {
        api.userSteps.adGroupsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAdGroups(
                                new AdGroupUpdateItemMap()
                                        .withId(pid)
                                        .withName("newName")
                        ),
                ExpectedResult.success()
        );
        GroupFakeInfo groupInfo = api.userSteps.groupFakeSteps().getGroupParams(pid);
        assumeThat("время последнего изменения группы", groupInfo.getLastChange(), notNullValue());
        LocalDate date = DATE_TIME_FORMATTER.parseLocalDate(groupInfo.getLastChange());
        assertThat("время последнего изменения группы", date, equalTo(LocalDate.now()));
    }
}
