package ru.yandex.autotests.direct.api.adgroups.update.cpmbanneradgroup;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.GroupFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(AdGroupsFeatures.UPDATE)
@Tag(TagDictionary.TRUNK)
@Issue("https://st.yandex-team.ru/DIRECT-83722")
public class CpmBannerAddGroupUpdateAndCheckStatusBsSynced {

    private static final String CLIENT = AdGroupsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long adGroupId;
    private Long adId;

    private String getGroupStatusBsSynced(Long adGroupID) {
        GroupFakeInfo groupFakeInfo = api.userSteps.groupFakeSteps().getGroupParams(adGroupID);
        return groupFakeInfo.getStatusBsSynced();
    }

    private String getBannerStatusBsSynced(Long bannerID) {
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(bannerID);
        return bannerFakeInfo.getStatusBsSynced();
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().setType(campaignId, CampaignsType.CPM_BANNER);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultCpmBannerKeywordsAdGroup(campaignId);
        Long creativeId = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT).perfCreativesSteps()
                .saveDefaultCanvasCreativesForClient(Long.parseLong(User.get(CLIENT).getClientID()));
        adId = api.userSteps.adsSteps().addDefaultCpmBannerAdBuilderAd(adGroupId, creativeId);

        api.userSteps.groupFakeSteps().setStatusModerate(adGroupId, Status.YES);
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(adGroupId, Status.YES);

        api.userSteps.bannersFakeSteps().makeBannersModerated(adId);
        api.userSteps.bannersFakeSteps().setStatusBsSynced(adId, Status.YES);

        assumeThat("группе установился нужный статус синхронизации с БК",
                getGroupStatusBsSynced(adGroupId),
                equalTo(Status.YES));
        assumeThat("баннеру установился нужный статус синхронизации с БК",
                getBannerStatusBsSynced(adId),
                equalTo(Status.YES));
    }

    @Test
    public void updateNegativeKeywords() {
        api.userSteps.adGroupsSteps().adGroupsUpdate(
                new UpdateRequestMap().withAdGroups(
                        new AdGroupUpdateItemMap()
                                .withId(adGroupId)
                                .withNegativeKeywords(AdGroupAddItemMap.DEFAULT_NEGATIVE_KEYWORD + "new")));

        assertThat("группа имеет правильный статус синхронизации с БК",
                getGroupStatusBsSynced(adGroupId),
                equalTo(Status.NO));
        assertThat("баннер имеет правильный статус синхронизации с БК",
                getBannerStatusBsSynced(adId),
                equalTo(Status.YES));
    }

    @Test
    @Issue("https://st.yandex-team.ru/DIRECT-51468#1457351722000")
    public void updateTrackingParams() {
        api.userSteps.adGroupsSteps().adGroupsUpdate(
                new UpdateRequestMap().withAdGroups(new AdGroupUpdateItemMap()
                        .withId(adGroupId)
                        .withTrackingParams(AdGroupAddItemMap.DEFAULT_TRACKING_PARAMS + "api")
                ));
        assertThat("группа имеет правильный статус синхронизации с БК",
                getGroupStatusBsSynced(adGroupId),
                equalTo(Status.NO));
        assertThat("баннер имеет правильный статус синхронизации с БК",
                getBannerStatusBsSynced(adId),
                equalTo(Status.YES));
    }
}
