package ru.yandex.autotests.direct.api.adgroups.update.dynamictextadgroup;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.GroupFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.DynamicTextAdGroupMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.common.RegionIDValues;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by zakhar on 10.03.16.
 * https://st.yandex-team.ru/TESTIRT-8657
 */
@Aqua.Test
@Features(AdGroupsFeatures.UPDATE)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class DynamicTextAdGroupUpdateGeoAndCheckStatusBsSyncedTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(AdGroupsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    Long adGroupId;
    Long firstAdId;
    Long secondAdId;

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String geoBeforeUpdate;

    @Parameterized.Parameter(2)
    public String geoAfterUpdate;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> testData() {
        Object[][] data = new Object[][]{
                {"Moscow -> Spb",
                        RegionIDValues.MOSCOW_ID, RegionIDValues.SPB_ID},
                {"Moscow -> Kazakhstan",
                        RegionIDValues.MOSCOW_ID, RegionIDValues.KAZAKH_REGION_ID},
                {"Kazakhstan -> Moscow",
                        RegionIDValues.KAZAKH_REGION_ID, RegionIDValues.MOSCOW_ID},
                {"Moscow region -> Leningrad region",
                        RegionIDValues.MOSCOW_AND_MOSCOW_REGION_ID, RegionIDValues.SPB_AND_LENINGRAD_REGION_ID},

        };
        return Arrays.asList(data);
    }

    private String getGroupStatusBsSynced(Long adGroupID) {
        GroupFakeInfo groupFakeInfo = api.userSteps.groupFakeSteps().getGroupParams(adGroupID);
        return groupFakeInfo.getStatusBsSynced();
    }

    private String getBannerStatusBsSynced(Long bannerID) {
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(bannerID);
        return bannerFakeInfo.getStatusBsSynced();
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createGroupAndBanner() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();

        adGroupId = api.userSteps.adGroupsSteps().addGroup(
                new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId)
                        .withDynamicTextAdGroup(new DynamicTextAdGroupMap().defaultGroup())
                        .withRegionIds(Long.parseLong(geoBeforeUpdate)));

        firstAdId = api.userSteps.adsSteps().addDefaultDynamicTextAd(adGroupId);
        secondAdId = api.userSteps.adsSteps().addDefaultDynamicTextAd(adGroupId);
        assumeThat("Создались 2 разных баннера", firstAdId, not(equalTo(secondAdId)));

        api.userSteps.groupFakeSteps().setStatusModerate(adGroupId, Status.YES);
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(adGroupId, Status.YES);

        api.userSteps.bannersFakeSteps().makeBannersModerated(firstAdId);
        api.userSteps.bannersFakeSteps().setStatusBsSynced(firstAdId, Status.YES);
        api.userSteps.bannersFakeSteps().makeBannersModerated(secondAdId);
        api.userSteps.bannersFakeSteps().setStatusBsSynced(secondAdId, Status.YES);

        assumeThat("группе установился нужный статус синхронизации с БК",
                getGroupStatusBsSynced(adGroupId),
                equalTo(Status.YES));
        assumeThat("первому баннеру установился нужный статус синхронизации с БК",
                getBannerStatusBsSynced(firstAdId),
                equalTo(Status.YES));
        assumeThat("второму баннеру установился нужный статус синхронизации с БК",
                getBannerStatusBsSynced(secondAdId),
                equalTo(Status.YES));
    }

    @Test
    public void updateGeo() {
        api.userSteps.adGroupsSteps().adGroupsUpdate(
                new UpdateRequestMap().withAdGroups(
                        new AdGroupUpdateItemMap().withId(adGroupId)
                                .withRegionIds(Long.parseLong(geoAfterUpdate))));
        assertThat("группа имеет правильный статус синхронизации с БК",
                getGroupStatusBsSynced(adGroupId),
                equalTo(Status.NO));
        assertThat("первый баннер имеет правильный статус синхронизации с БК",
                getBannerStatusBsSynced(firstAdId),
                equalTo(Status.NO));
        assertThat("второй баннер имеет правильный статус синхронизации с БК",
                getBannerStatusBsSynced(secondAdId),
                equalTo(Status.NO));
    }

}
