package ru.yandex.autotests.direct.api.adgroups.update.dynamictextadgroup;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.GroupFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.DynamicTextAdGroupMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by buhter on 25.11.15.
 * https://st.yandex-team.ru/TESTIRT-7819
 * https://st.yandex-team.ru/TESTIRT-8657
 */
@Aqua.Test
@Features(AdGroupsFeatures.UPDATE)
@Stories(AdGroupsStories.DYNAMIC_TEXT)
@Tag(TagDictionary.TRUNK)
@Issue("https://st.yandex-team.ru/DIRECT-41334")
public class DynamicTextAddGroupUpdateAndCheckStatusBsSynced {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(AdGroupsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long adGroupId;
    private Long adId;

    private String getGroupStatusBsSynced(Long adGroupID) {
        GroupFakeInfo groupFakeInfo = api.userSteps.groupFakeSteps().getGroupParams(adGroupID);
        return groupFakeInfo.getStatusBsSynced();
    }

    private String getBannerStatusBsSynced(Long bannerID) {
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(bannerID);
        return bannerFakeInfo.getStatusBsSynced();
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
        Integer campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign().intValue();
        adGroupId = api.userSteps.adGroupsSteps().addGroup(
                new AdGroupAddItemMap()
                        .defaultAdGroupAddItem(campaignId.longValue())
                        .withTrackingParams(AdGroupAddItemMap.DEFAULT_TRACKING_PARAMS)
                        .withDynamicTextAdGroup(
                                new DynamicTextAdGroupMap()
                                        .defaultGroup()));
        adId = api.userSteps.adsSteps().addDefaultDynamicTextAd(adGroupId);

        api.userSteps.groupFakeSteps().setStatusModerate(adGroupId, Status.YES);
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(adGroupId, Status.YES);

        api.userSteps.bannersFakeSteps().makeBannersModerated(adId);
        api.userSteps.bannersFakeSteps().setStatusBsSynced(adId, Status.YES);

        assumeThat("группе установился нужный статус синхронизации с БК",
                getGroupStatusBsSynced(adGroupId),
                equalTo(Status.YES));
        assumeThat("баннеру установился нужный статус синхронизации с БК",
                getBannerStatusBsSynced(adId),
                equalTo(Status.YES));
    }

    @Test
    public void updateDomain() {
        api.userSteps.adGroupsSteps().adGroupsUpdate(
                new UpdateRequestMap().withAdGroups(
                        new AdGroupUpdateItemMap()
                            .withId(adGroupId)
                            .withDynamicTextAdGroup(new DynamicTextAdGroupMap()
                                    .withDomainUrl(DynamicTextAdGroupMap.ANOTHER_DOMAIN_URL))));

        assertThat("для группы статус синхронизации с БК не изменился",
                getGroupStatusBsSynced(adGroupId),
                equalTo(Status.NO));//но не должен
        assertThat("баннер имеет правильный статус синхронизации с БК",
                getBannerStatusBsSynced(adId),
                equalTo(Status.NO));
    }

    @Test
    public void updateNegativeKeywords() {
        api.userSteps.adGroupsSteps().adGroupsUpdate(
                new UpdateRequestMap().withAdGroups(
                        new AdGroupUpdateItemMap()
                                .withId(adGroupId)
                                .withNegativeKeywords(AdGroupAddItemMap.DEFAULT_NEGATIVE_KEYWORD + "new")));

        assertThat("группа имеет правильный статус синхронизации с БК",
                getGroupStatusBsSynced(adGroupId),
                equalTo(Status.NO));
        assertThat("баннер имеет правильный статус синхронизации с БК",
                getBannerStatusBsSynced(adId),
                equalTo(Status.NO));
    }

    @Test
    @Issue("https://st.yandex-team.ru/DIRECT-51468#1457351722000")
    public void updateTrackingParams() {
        api.userSteps.adGroupsSteps().adGroupsUpdate(
                new UpdateRequestMap().withAdGroups(new AdGroupUpdateItemMap()
                        .withId(adGroupId)
                        .withTrackingParams(AdGroupAddItemMap.DEFAULT_TRACKING_PARAMS+"api")
                ));
        assertThat("группа имеет правильный статус синхронизации с БК",
                getGroupStatusBsSynced(adGroupId),
                equalTo(Status.NO));
        assertThat("баннер имеет правильный статус синхронизации с БК",
                getBannerStatusBsSynced(adId),
                equalTo(Status.NO));
    }
}
