package ru.yandex.autotests.direct.api.adgroups.update.dynamictextadgroup;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdgroupsDynamicStatusblgenerated;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdgroupsDynamicRecord;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.DynamicTextAdGroupMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by buhter on 17.12.15.
 * https://st.yandex-team.ru/TESTIRT-7965
 */
@Aqua.Test
@Features(AdGroupsFeatures.UPDATE)
@Stories(AdGroupsStories.DYNAMIC_TEXT)
@Issue("https://st.yandex-team.ru/DIRECT-49484")
public class DynamicTextAddGroupUpdateDraftAndCheckStatusBlGenerated {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(AdGroupsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static int shard;
    private Long pid;
    private int campaignId;

    @BeforeClass
    public static void init() {
        shard = api.userSteps.clientFakeSteps().getUserShard(AdGroupsLogins.CLIENT);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign().intValue();
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid, AdGroupsLogins.CLIENT);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps().setAdgroupsDynamicStatusBlGenerated(pid,
                AdgroupsDynamicStatusblgenerated.No);
    }

    @Test
    public void updateDomain() {
        api.userSteps.adGroupsSteps().adGroupsUpdate(
                new UpdateRequestMap().withAdGroups(new AdGroupUpdateItemMap()
                        .withId(pid)
                        .withDynamicTextAdGroup(new DynamicTextAdGroupMap()
                                .withDomainUrl(DynamicTextAdGroupMap.ANOTHER_DOMAIN_URL)
                        )
                ));
        AdgroupsDynamicRecord adgroupsDynamicRecord =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).adgroupsDynamicSteps().getAdgroupsDynamic(pid);
        assertThat("statusBlGenerated не обновился"
                , adgroupsDynamicRecord.getStatusblgenerated(), equalTo(AdgroupsDynamicStatusblgenerated.No));
    }
}
