package ru.yandex.autotests.direct.api.adgroups.update.dynamictextadgroup;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.DynamicTextAdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.GetResponse;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.DynamicTextAdGroupGetMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.DynamicTextAdGroupMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.iterableWithSize;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by buhter on 25.11.15.
 * https://st.yandex-team.ru/TESTIRT-7819
 */
@Aqua.Test
@Features(AdGroupsFeatures.UPDATE)
@Stories(AdGroupsStories.DYNAMIC_TEXT)
@Issue("https://st.yandex-team.ru/DIRECT-41334")
public class DynamicTextAddGroupUpdateSetOfFieldsTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(AdGroupsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Integer campaignId;
    private Long id;
    private GetRequestMap getRequestMap;
    private DynamicTextAdGroupGetMap expected;

    @BeforeClass
    public static void initTest() {
        campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign().intValue();
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
        id = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
        getRequestMap = new GetRequestMap()
                .withSelectionCriteria(
                        new AdGroupsSelectionCriteriaMap()
                                .withIds(id)
                )
                .withFieldNames(AdGroupFieldEnum.ID)
                .withDynamicTextAdGroupFieldNames(
                        DynamicTextAdGroupFieldEnum.DOMAIN_URL
                );
        expected = new DynamicTextAdGroupGetMap().withDomainUrl(DynamicTextAdGroupMap.DEFAULT_DOMAIN_URL);
    }

    @Test
    public void updateWithOnlyId() {
        api.userSteps.adGroupsSteps().adGroupsUpdate(
                new UpdateRequestMap().withAdGroups(new AdGroupUpdateItemMap()
                        .withId(id))
        );
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(getRequestMap);

        assumeThat("вернулась одна группа", response.getAdGroups(), iterableWithSize(1));
        assertThat("вернулась правильная группа", response.getAdGroups().get(0).getDynamicTextAdGroup(),
                beanDifferV5(expected.getBean()));
    }

    @Test
    public void updateDomain() {
        api.userSteps.adGroupsSteps().adGroupsUpdate(
                new UpdateRequestMap().withAdGroups(new AdGroupUpdateItemMap()
                        .withId(id)
                        .withDynamicTextAdGroup(new DynamicTextAdGroupMap()
                                .withDomainUrl(DynamicTextAdGroupMap.ANOTHER_DOMAIN_URL)
                        )
                ));

        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(getRequestMap);
        assumeThat("вернулась одна группа", response.getAdGroups(), iterableWithSize(1));
        assertThat("вернулась правильная группа", response.getAdGroups().get(0).getDynamicTextAdGroup(),
                beanDifferV5(expected.withDomainUrl(DynamicTextAdGroupMap.ANOTHER_DOMAIN_URL).getBean()));
    }

}
