package ru.yandex.autotests.direct.api.adgroups.update.dynamictextfeedadgroup;

import java.util.Collections;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.GetResponse;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupGetItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.DynamicTextAdGroupMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Author gerdler
 * Date 23.08.16
 * https://jira.yandex-team.ru/browse/TESTIRT-10035
 */
@Aqua.Test
@Features(AdGroupsFeatures.UPDATE)
@Stories(AdGroupsStories.DYNAMIC_TEXT_FEED)
@Issue("https://st.yandex-team.ru/DIRECT-55195")
@Description("Проверка обновления общих полей у ДО-группы с фидом")
public class DynamicTextFeedAdGroupUpdateCommonFieldsTest {
    private static final String LOGIN = AdGroupsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long campaignId;
    private static Long feedId;
    private Long adGroupId;
    private GetRequestMap getRequestMap;
    private static DirectJooqDbSteps jooqDbSteps;
    private static AdGroupGetItemMap expectedResult;

    @BeforeClass
    public static void initTest() {
        campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        int shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        feedId = jooqDbSteps.feedsSteps().createDefaultFeed(User.get(LOGIN).getClientID());
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        adGroupId = api.userSteps.adGroupsSteps().addGroup(new AdGroupAddItemMap()
                .defaultAdGroupAddItem(campaignId)
                .withNegativeKeywords(AdGroupAddItemMap.DEFAULT_NEGATIVE_KEYWORD)
                .withTrackingParams(AdGroupAddItemMap.DEFAULT_TRACKING_PARAMS)
                .withDynamicTextAdGroup(new DynamicTextAdGroupMap().defaultGroup())
        );
        jooqDbSteps.adGroupsSteps().convertAdgroupDynamicToDynamicByFeed(adGroupId, feedId);

        getRequestMap = new GetRequestMap()
                .withSelectionCriteria(
                        new AdGroupsSelectionCriteriaMap()
                                .withIds(adGroupId)
                )
                .withFieldNames(
                        AdGroupFieldEnum.ID,
                        AdGroupFieldEnum.CAMPAIGN_ID,
                        AdGroupFieldEnum.NAME,
                        AdGroupFieldEnum.REGION_IDS,
                        AdGroupFieldEnum.NEGATIVE_KEYWORDS,
                        AdGroupFieldEnum.TRACKING_PARAMS
                );
        expectedResult = new AdGroupGetItemMap()
                .withId(adGroupId)
                .withCampaignId(campaignId)
                .withName(AdGroupAddItemMap.DEFAULT_NAME)
                .withRegionIds(AdGroupAddItemMap.DEFAULT_REGION_ID)
                .withNegativeKeywords(AdGroupAddItemMap.DEFAULT_NEGATIVE_KEYWORD)
                .withTrackingParams(AdGroupAddItemMap.DEFAULT_TRACKING_PARAMS);
    }

    @Test
    public void updateWithOnlyId() {
        api.userSteps.adGroupsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAdGroups(new AdGroupUpdateItemMap()
                        .withId(adGroupId)),
                ExpectedResult.success()
        );
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(getRequestMap);
        assertThat("вернулась правильная группа", response.getAdGroups(), beanDifferV5(
                Collections.singletonList(expectedResult.getBean())));
    }

    @Test
    public void updateOnlyName() {
        api.userSteps.adGroupsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAdGroups(new AdGroupUpdateItemMap()
                        .withId(adGroupId)
                        .withName(AdGroupAddItemMap.DEFAULT_NAME + "new")),
                ExpectedResult.success()
        );
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(getRequestMap);
        assertThat("вернулась правильная группа", response.getAdGroups(),
                beanDifferV5(Collections
                        .singletonList(expectedResult.withName(AdGroupAddItemMap.DEFAULT_NAME + "new").getBean())));
    }

    @Test
    public void updateOnlyRegionIds() {
        api.userSteps.adGroupsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAdGroups(new AdGroupUpdateItemMap()
                        .withId(adGroupId)
                        .withRegionIds(AdGroupAddItemMap.DEFAULT_REGION_ID + 1)),
                ExpectedResult.success()
        );
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(getRequestMap);
        assertThat("вернулась правильная группа", response.getAdGroups(),
                beanDifferV5(Collections
                        .singletonList(expectedResult.withRegionIds(AdGroupAddItemMap.DEFAULT_REGION_ID + 1).getBean())));
    }

    @Test
    public void updateOnlyNegativeKeywords() {
        api.userSteps.adGroupsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAdGroups(new AdGroupUpdateItemMap()
                        .withId(adGroupId)
                        .withNegativeKeywords(AdGroupAddItemMap.DEFAULT_NEGATIVE_KEYWORD + "new")),
                ExpectedResult.success()
        );
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(getRequestMap);
        assertThat("вернулась правильная группа", response.getAdGroups(),
                beanDifferV5(Collections.singletonList(
                        expectedResult.withNegativeKeywords(AdGroupAddItemMap.DEFAULT_NEGATIVE_KEYWORD + "new")
                                .getBean())));
    }

    @Test
    public void updateOnlyTrackingParams() {
        api.userSteps.adGroupsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAdGroups(new AdGroupUpdateItemMap()
                        .withId(adGroupId)
                        .withTrackingParams(AdGroupAddItemMap.DEFAULT_TRACKING_PARAMS + "new")),
                ExpectedResult.success()
        );
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(getRequestMap);
        assertThat("вернулась правильная группа", response.getAdGroups(),
                beanDifferV5(Collections.singletonList(
                        expectedResult.withTrackingParams(AdGroupAddItemMap.DEFAULT_TRACKING_PARAMS + "new").getBean())));
    }

    @Test
    public void updateAllFields() {
        api.userSteps.adGroupsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAdGroups(new AdGroupUpdateItemMap()
                        .withId(adGroupId)
                        .withName(AdGroupAddItemMap.DEFAULT_NAME + "new")
                        .withRegionIds(AdGroupAddItemMap.DEFAULT_REGION_ID + 1)
                        .withNegativeKeywords(AdGroupAddItemMap.DEFAULT_NEGATIVE_KEYWORD + "new")
                        .withTrackingParams(AdGroupAddItemMap.DEFAULT_TRACKING_PARAMS + "new")),
                ExpectedResult.success()
        );
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(getRequestMap);
        assertThat("вернулась правильная группа", response.getAdGroups(),
                beanDifferV5(Collections.singletonList(expectedResult
                        .withName(AdGroupAddItemMap.DEFAULT_NAME + "new")
                        .withRegionIds(AdGroupAddItemMap.DEFAULT_REGION_ID + 1)
                        .withNegativeKeywords(AdGroupAddItemMap.DEFAULT_NEGATIVE_KEYWORD + "new")
                        .withTrackingParams(AdGroupAddItemMap.DEFAULT_TRACKING_PARAMS + "new")
                        .getBean())
                )
        );
    }

}
